"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from PyTQt.tqt import TQLabel, TQWidget, SIGNAL
from tdecore import TDEApplication, TDEIcon, TDEIconLoader
from tdeui import TDEMainWindow, KSystemTray

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        self.exitFlag = False

        icons = TDEIconLoader ()

        self.systray = KSystemTray (self)
        self.systray.setPixmap (icons.loadIcon("process-stop", TDEIcon.Desktop))
        self.systray.connect (self.systray, SIGNAL ("quitSelected ()"), self.slotQuitSelected)
        self.systray.show ()

    def queryClose (self):
        self.hide ()
        return self.exitFlag

    def slotQuitSelected (self):
        self.exitFlag = True
        TDEApplication.kApplication ().quit ()

#-------------------- main ------------------------------------------------


appName = "template"
app = TDEApplication (sys.argv, appName)
mainWindow = MainWin (None, "main window")

mainWindow.show()
app.exec_loop()


