from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQTimer, SIGNAL, TQFont, TQString
from tdecore import i18n
from tdeui import KPushButton, KEdReplace, KTextEdit

iconName = 'findreplace'
labelText = 'KEdReplace'
docParts = ('tdeui', 'KEdReplace')
helpText = ("An example of the KEdReplace dialog.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Edit Find Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showEdReplace)


    def showEdReplace(self):
        dlg = self.dlg = KEdReplace(self)
        self.connect(dlg, SIGNAL('done()'),
                    self.doneClicked)
        self.connect(dlg, SIGNAL('replace()'),
                    self.replaceClicked)        
        dlg.exec_loop()


    def doneClicked(self):
        print('done replacing')

    def replaceClicked(self):
        print('replacing: ', self.dlg.getText())
        return
        if self.dlg.get_direction():
            print('(backwards) ', end=' ')
        else:
            print('(forwards) ', end=' ')
        if self.dlg.case_sensitive():
            print('(case-sensitive)')
        else:
            print('(case-insensitive)')
        

        

