/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DEVICE_XML_TO_DATA_H
#define DEVICE_XML_TO_DATA_H

#include <tqmap.h>
#include <tqfile.h>
#include <tqtextstream.h>

#include "common/common/misc.h"
#include "common/common/streamer.h"
#include "devices/base/generic_device.h"
#include "xml_to_data.h"

namespace Device
{
class XmlToDataBase : public ::XmlToData
{
public:
  XmlToDataBase(const TQString &folder) : XmlToData(folder), _data(0) {}

protected:
  mutable Data *_data;
  TQMap<TQString, Data *> _map;          // device -> data

  virtual void parse();
  virtual TQString currentDevice() const { return (_data ? _data->name() : TQString()); }
  virtual TQString namespaceName() const = 0;
  virtual Data *createData() const = 0;
  virtual void processDevice(TQDomElement device);
  virtual void checkPins(const TQMap<TQString, uint> &pinLabels) const = 0;

private:
  TQMap<TQString, TQString>     _documents;    // document -> device
  TQMap<TQString, TQStringList> _alternatives; // device -> alternatives

  bool getFrequencyRange(OperatingCondition oc, Special special, TQDomElement element);
  bool getMemoryTechnology(TQDomElement element);
  Device::Package processPackage(TQDomElement element);
};

template <class DataType>
class XmlToData : public XmlToDataBase, public DataStreamer<DataType>
{
public:
  XmlToData(const TQString &folder) : XmlToDataBase(folder) {}
  virtual Device::Data *createData() const { return new DataType; }
  DataType *data() { return static_cast<DataType *>(_data); }
  const DataType *data() const { return static_cast<DataType *>(_data); }
  virtual void output() {
    TQFile dfile("deps.mak");
    if ( !dfile.open(IO_WriteOnly) ) return;
    TQTextStream dts(&dfile);
    dts << "noinst_DATA = ";
    uint i = 0;
    TQMap<TQString, Data *>::const_iterator it;
    for (it=_map.begin(); it!=_map.end(); ++it) {
      if ( (i%10)==0 ) dts << "\\" << endl << "    ";
      dts << " " << it.key() << ".xml";
      i++;
    }
    dts << endl;
    dfile.close();

    TQFile file(namespaceName().lower() + "_data.cpp");
    if ( !file.open(IO_WriteOnly) ) return;
    TQTextStream ts(&file);
    ts << "#include \"devices/" << namespaceName().lower() << "/"
       << namespaceName().lower() << "/" << namespaceName().lower() << "_group.h\"" << endl << endl;
    ts << "const char *" << namespaceName() << "::DATA_STREAM =" << endl;
    TQValueList<DataType *> list;
    for (it=_map.begin(); it!=_map.end(); ++it)
      list.append(const_cast<DataType *>(static_cast<const DataType *>(it.data())));
    uint size = this->toCppString(list, ts);
    ts << ";" << endl;
    ts << "const uint " << namespaceName() << "::DATA_SIZE = " << size << ";" << endl;
    file.close();
  }
};

} // namespace

#endif
