#ifndef KEYPAD_H
#define KEYPAD_H

#include <tqwidget.h>
#include <tqpushbutton.h>
#include <tqstring.h>

class TQCloseEvent;

class CharButton : public TQPushButton
{
	Q_OBJECT

public:
	CharButton(const TQString &text, TQWidget *parent=0, const char *name=0);
	~CharButton() {}

signals:
	void clicked(const TQString &);

private slots:
	void emitClicked();

private:
	TQString m_text;
};

class MathKeypad : public TQWidget 
{
	Q_OBJECT

public:
	MathKeypad(TQWidget *parent=0, const char *name=0);
	~MathKeypad() {}

signals:
	void closing();
	void insertChar(const TQString &);

	void add();
	void subtract();
	void multiply();
	void divide();
	void enter();
	void backspace();
	void eex();

protected:
	void closeEvent(TQCloseEvent *);
};

#endif
