/*

Copyright (C) 2010-2011 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_H
#define TQT_H

#define USE_QT@QT_VERSION@

#ifndef TQT_VERSION_ONLY

#ifdef TQT_METHOD
#undef TQT_METHOD
#endif
#ifdef TQT_SLOT
#undef TQT_SLOT
#endif
#ifdef TQT_SIGNAL
#undef TQT_SIGNAL
#endif

#ifdef __cplusplus
#define TQT_METHOD(a)	METHOD(a)
#define TQT_SLOT(a)	SLOT(a)
#define TQT_SIGNAL(a)	SIGNAL(a)
#endif /* __cplusplus */


#include <ntqglobal.h>

#ifdef QT_NO_SQL
#define TQT_NO_SQL
#endif /* QT_NO_SQL */

#ifdef Q_WS_X11
#define TQ_WS_X11
#endif /* Q_WS_X11 */

#define Qt TQt
#ifndef TQT_NO_COMPAT_NAMES
#define Q_OBJECT		TQ_OBJECT
#endif /* TQT_NO_COMPAT_NAMES */

#define TQ_INLINE_TEMPLATES		Q_INLINE_TEMPLATES
#define TQ_DUMMY_COMPARISON_OPERATOR	Q_DUMMY_COMPARISON_OPERATOR
#define TQ_REFCOUNT			Q_REFCOUNT
#define TQ_TYPENAME			Q_TYPENAME

#define TQ_BYTE_ORDER			Q_BYTE_ORDER
#define TQ_LITTLE_ENDIAN		Q_LITTLE_ENDIAN
#define TQ_BIG_ENDIAN			Q_BIG_ENDIAN

#define TQT_CHECK_INVALID_MAP_ELEMENT	QT_CHECK_INVALID_MAP_ELEMENT

#define TQT_PRODUCT_LICENSEE		QT_PRODUCT_LICENSEE

#define TQT_TRANSLATE_NOOP		QT_TRANSLATE_NOOP

#define TQ_StrongFocus          TQWidget::StrongFocus
#define TQ_NoFocus              TQWidget::NoFocus
#define TQ_WheelFocus           TQWidget::WheelFocus
#define TQ_ClickFocus           TQWidget::ClickFocus
#define TQ_TabFocus             TQWidget::TabFocus
#define TQ_FocusPolicy          TQWidget::FocusPolicy
#define TQ_ScaleFree            TQImage::ScaleFree
#define TQ_ScaleMin             TQImage::ScaleMin
#define TQ_ScaleMax             TQImage::ScaleMax
#define TQ_ScaleMode            TQImage::ScaleMode

#define TQ_PrimitiveElement	PrimitiveElement
#define TQ_StyleHint		StyleHint
#define TQ_Horizontal		Horizontal
#define TQ_Vertical		Vertical
#define TQ_Alignment		Qt::AlignmentFlags
#define TQ_Key_Shift		Key_Shift
#define TQ_Key_Control		Key_Control
#define TQ_Key_Alt		Key_Alt
#define TQ_Key_Meta		Key_Meta
#define TQ_Key_Super_L		Key_Super_L
#define TQ_Key_Super_R		Key_Super_R
#define TQ_Key_Hyper_L		Key_Hyper_L
#define TQ_Key_Hyper_R		Key_Hyper_R
#define TQ_ButtonState		Qt::ButtonState
#define TQ_LeftButton		LeftButton
#define TQ_MidButton		MidButton
#define TQ_RightButton		RightButton
#define TQ_ShiftButton		ShiftButton
#define TQ_ControlButton	ControlButton
#define TQ_AltButton		AltButton
#define TQ_MetaButton		MetaButton
#define TQ_WFlags		TQt::WFlags
#define TQ_OpenMode		int
#define TQ_SPVertically		TQSizePolicy::Vertically
#define TQ_SPHorizontally	TQSizePolicy::Horizontally
#define TQ_SPNoDirection	TQSizePolicy::NoDirection

#define tqtr			tr
#define tqaccess		access
#define tqcolorTable		colorTable
#define TQSO_Default		Default
#define SO_Default		Default
#define tqstrcmp		qstrcmp
#define tqt_dynamic_cast	dynamic_cast
#define TQImage_ScaleFree	QImage::ScaleFree
#define TQIODevice_OpenModeFlag int

#define tqqt_cast		tqt_cast

#define TQAPPLICATION_OBJECT_NAME_STRING	"TQApplication"
#define TQVARIANT_OBJECT_NAME_STRING		"TQVariant"
#define TQPOINT_OBJECT_NAME_STRING		"TQPoint"
#define TQRECT_OBJECT_NAME_STRING		"TQRect"
#define TQMAP_OBJECT_NAME_STRING		"TQMap"
#define TQCOLOR_OBJECT_NAME_STRING		"TQColor"
#define TQCOLORGROUP_OBJECT_NAME_STRING		"TQColorGroup"
#define TQVALUELIST_OBJECT_NAME_STRING		"TQValueList"
#define TQICONSET_OBJECT_NAME_STRING		"TQIconSet"
#define TQDATASTREAM_OBJECT_NAME_STRING		"TQDataStream"
#define TQPOINTARRAY_OBJECT_NAME_STRING		"TQPointArray"
#define TQREGION_OBJECT_NAME_STRING		"TQRegion"
#define TQBITMAP_OBJECT_NAME_STRING		"TQBitmap"
#define TQSIZEPOLICY_OBJECT_NAME_STRING		"TQSizePolicy"
#define TQKEYSEQUENCE_OBJECT_NAME_STRING	"TQKeySequence"
#define TQDATE_OBJECT_NAME_STRING		"TQDate"
#define TQTIME_OBJECT_NAME_STRING		"TQTime"
#define TQDATETIME_OBJECT_NAME_STRING		"TQDateTime"
#define TQCURSOR_OBJECT_NAME_STRING		"TQCursor"
#define TQPALETTE_OBJECT_NAME_STRING		"TQPalette"
#define TQIMAGE_OBJECT_NAME_STRING		"TQImage"
#define TQSIZE_OBJECT_NAME_STRING		"TQSize"
#define TQBITARRAY_OBJECT_NAME_STRING		"TQBitArray"
#define TQBYTEARRAY_OBJECT_NAME_STRING		"TQByteArray"
#define TQFONT_OBJECT_NAME_STRING		"TQFont"
#define TQBRUSH_OBJECT_NAME_STRING		"TQBrush"
#define TQPIXMAP_OBJECT_NAME_STRING		"TQPixmap"
#define TQSTRING_OBJECT_NAME_STRING		"TQString"
#define TQCSTRING_OBJECT_NAME_STRING		"TQCString"
#define TQSTRINGLIST_OBJECT_NAME_STRING		"TQStringList"
#define TQLAYOUT_OBJECT_NAME_STRING		"TQLayout"
#define TQBOXLAYOUT_OBJECT_NAME_STRING		"TQBoxLayout"
#define TQHBOXLAYOUT_OBJECT_NAME_STRING		"TQHBoxLayout"
#define TQVBOXLAYOUT_OBJECT_NAME_STRING		"TQVBoxLayout"
#define TQGRIDLAYOUT_OBJECT_NAME_STRING		"TQGridLayout"
#define TQHBOX_OBJECT_NAME_STRING		"TQHBox"
#define TQVBOX_OBJECT_NAME_STRING		"TQVBox"
#define TQGRID_OBJECT_NAME_STRING		"TQGrid"
#define TQTABWIDGET_OBJECT_NAME_STRING		"TQTabWidget"
#define TQCHECKBOX_OBJECT_NAME_STRING		"TQCheckBox"
#define TQLINEEDIT_OBJECT_NAME_STRING		"TQLineEdit"
#define TQTEXTEDIT_OBJECT_NAME_STRING		"TQTextEdit"
#define TQOBJECT_OBJECT_NAME_STRING		"TQObject"
#define TQWIDGET_OBJECT_NAME_STRING		"TQWidget"
#define TQGLWIDGET_OBJECT_NAME_STRING		"TQGLWidget"
#define TQLABEL_OBJECT_NAME_STRING		"TQLabel"
#define TQTIMER_OBJECT_NAME_STRING		"TQTimer"
#define TQFRAME_OBJECT_NAME_STRING		"TQFrame"
#define TQACCEL_OBJECT_NAME_STRING		"TQAccel"
#define TQDIALOG_OBJECT_NAME_STRING		"TQDialog"
#define TQDIAL_OBJECT_NAME_STRING		"TQDial"
#define TQACTION_OBJECT_NAME_STRING		"TQAction"
#define TQACTIONGROUP_OBJECT_NAME_STRING	"TQActionGroup"
#define TQLCDNUMBER_OBJECT_NAME_STRING		"TQLCDNumber"
#define TQPROGRESSBAR_OBJECT_NAME_STRING	"TQProgressBar"
#define TQTABDIALOG_OBJECT_NAME_STRING		"TQTabDialog"
#define TQTABWIDGET_OBJECT_NAME_STRING		"TQTabWidget"
#define TQDOCKWINDOW_OBJECT_NAME_STRING		"TQDockWindow"
#define TQGROUPBOX_OBJECT_NAME_STRING		"TQGroupBox"
#define TQCOMBOBOX_OBJECT_NAME_STRING		"TQComboBox"
#define TQSPINBOX_OBJECT_NAME_STRING		"TQSpinBox"
#define TQSPINWIDGET_OBJECT_NAME_STRING		"TQSpinWidget"
#define TQLISTBOX_OBJECT_NAME_STRING		"TQListBox"
#define TQTOOLBOX_OBJECT_NAME_STRING		"TQToolBox"
#define TQTOOLTIP_OBJECT_NAME_STRING		"TQToolTip"
#define TQTIPLABEL_OBJECT_NAME_STRING		"TQTipLabel"
#define TQTOOLBOXBUTTON_OBJECT_NAME_STRING	"TQToolBoxButton"
#define TQVGROUPBOX_OBJECT_NAME_STRING		"TQVGroupBox"
#define TQSPLITTER_OBJECT_NAME_STRING		"TQSplitter"
#define TQSPLITTERHANDLE_OBJECT_NAME_STRING	"TQSplitterHandle"
#define TQBUTTON_OBJECT_NAME_STRING		"TQButton"
#define TQGRIDVIEW_OBJECT_NAME_STRING		"TQGridView"
#define TQSLIDER_OBJECT_NAME_STRING		"TQSlider"
#define TQPUSHBUTTON_OBJECT_NAME_STRING		"TQPushButton"
#define TQTOOLBUTTON_OBJECT_NAME_STRING		"TQToolButton"
#define TQRADIOBUTTON_OBJECT_NAME_STRING	"TQRadioButton"
#define TQPOPUPMENU_OBJECT_NAME_STRING		"TQPopupMenu"
#define TQTOOLBAR_OBJECT_NAME_STRING		"TQToolBar"
#define TQTOOLBAREXTENSIONWIDGET_OBJECT_NAME_STRING	"TQToolBarExtensionWidget"
#define TQMENUBAR_OBJECT_NAME_STRING		"TQMenuBar"
#define TQTABBAR_OBJECT_NAME_STRING		"TQTabBar"
#define TQLISTVIEW_OBJECT_NAME_STRING		"TQListView"
#define TQSCROLLBAR_OBJECT_NAME_STRING		"TQScrollBar"
#define TQSCROLLVIEW_OBJECT_NAME_STRING		"TQScrollView"
#define TQRANGECONTROL_OBJECT_NAME_STRING	"TQRangeControl"
#define TQCANVASITEM_OBJECT_NAME_STRING		"TQCanvasItem"
#define TQICONVIEW_OBJECT_NAME_STRING		"TQIconView"
#define TQMULTILINEEDIT_OBJECT_NAME_STRING	"TQMultiLineEdit"
#define TQINTVALIDATOR_OBJECT_NAME_STRING	"TQIntValidator"
#define TQDATEEDIT_OBJECT_NAME_STRING		"TQDateEdit"
#define TQTIMEEDIT_OBJECT_NAME_STRING		"TQTimeEdit"
#define TQDATETIMEEDIT_OBJECT_NAME_STRING	"TQDateTimeEdit"
#define TQHEADER_OBJECT_NAME_STRING		"TQHeader"
#define TQSIZEGRIP_OBJECT_NAME_STRING		"TQSizeGrip"
#define TQDOCKWINDOWHANDLE_OBJECT_NAME_STRING	"TQDockWindowHandle"
#define TQDOCKWINDOWRESIZEHANDLE_OBJECT_NAME_STRING		"TQDockWindowResizeHandle"
#define TQHIDEDOCK_OBJECT_NAME_STRING		"TQHideDock"
#define TQTABLE_OBJECT_NAME_STRING		"TQTable"
#define TQWIZARD_OBJECT_NAME_STRING		"TQWizard"
#define TQDATATABLE_OBJECT_NAME_STRING		"TQDataTable"
#define TQDATABROWSER_OBJECT_NAME_STRING	"TQDataBrowser"
#define TQDATAVIEW_OBJECT_NAME_STRING		"TQDataView"
#define TQMAINWINDOW_OBJECT_NAME_STRING		"TQMainWindow"
#define TQWIDGETSTACK_OBJECT_NAME_STRING	"TQWidgetStack"
#define TQBUTTONGROUP_OBJECT_NAME_STRING	"TQButtonGroup"
#define TQTEXTVIEW_OBJECT_NAME_STRING		"TQTextView"
#define TQTEXTBROWSER_OBJECT_NAME_STRING	"TQTextBrowser"
#define TQLAYOUTWIDGET_OBJECT_NAME_STRING	"TQLayoutWidget"
#define TQSTATUSBAR_OBJECT_NAME_STRING		"TQStatusBar"

#define TQMOTIFPLUSSTYLE_OBJECT_NAME_STRING	"TQMotifPlusStyle"

#define TQ_INT8_OBJECT_NAME_STRING		"TQ_INT8"
#define TQ_UINT8_OBJECT_NAME_STRING		"TQ_UINT8"
#define TQ_INT16_OBJECT_NAME_STRING		"TQ_INT16"
#define TQ_UINT16_OBJECT_NAME_STRING		"TQ_UINT16"
#define TQ_INT32_OBJECT_NAME_STRING		"TQ_INT32"
#define TQ_UINT32_OBJECT_NAME_STRING		"TQ_UINT32"
#define TQ_INT64_OBJECT_NAME_STRING		"TQ_INT64"
#define TQ_UINT64_OBJECT_NAME_STRING		"TQ_UINT64"
#define TQ_LLONG_OBJECT_NAME_STRING		"TQ_LLONG"
#define TQ_ULLONG_OBJECT_NAME_STRING		"TQ_ULLONG"
#define TQ_LONG_OBJECT_NAME_STRING		"TQ_LONG"
#define TQ_ULONG_OBJECT_NAME_STRING		"TQ_ULONG"

#define TQAlignCenter AlignCenter
#define TQNoBrush NoBrush

#define tqred red
#define tqgreen green
#define tqblue blue
#define tqcyan cyan
#define tqmagenta magenta
#define tqyellow yellow
#define tqdarkRed darkRed
#define tqdarkGreen darkGreen
#define tqdarkBlue darkBlue
#define tqdarkCyan darkCyan
#define tqdarkMagenta darkMagenta
#define tqdarkYellow darkYellow
#define tqwhite white
#define tqwhiteptr &Qt::white
#define tqlightGray lightGray
#define tqgray gray
#define tqdarkGray darkGray
#define tqblack black
#define tqblackptr &Qt::black
#define tqcolor0 color0
#define tqcolor1 color1

#define IID_TQUnknown IID_QUnknown
#define IID_TQComponentInformation IID_QComponentInformation
#define IID_TQWidgetFactory IID_QWidgetFactory

#ifndef TQT_NO_COMPAT_NAMES

#define qint64		long
#define quint64		unsigned long

#define QObject TQObject
#define QWidget TQWidget
#define QImage TQImage
#define QPair TQPair
#define QRgb TQRgb
#define QColor TQColor
#define QChar TQChar
#define QString TQString
#define QIODevice TQIODevice

#endif

#define tqmoc	moc
#define TQMOC	MOC

#define WPaintOnScreen	((WFlags)0)

#define TQRGB_MASK	TQT_RGB_MASK

#define tqInstallMsgHandler	qInstallMsgHandler

#define tqdrawPrimitive			drawPrimitive

#define tqsizeFromContents		sizeFromContents

#define QMIN		TQMIN
#define QMAX		TQMAX
#define QABS		TQABS

#define tqMakePair	qMakePair

#define tqt_ucm_query_verification_data	qt_ucm_query_verification_data

#define TQ_ControlElement	ControlElement
#define TQ_ComplexControl	ComplexControl

#define static_TQUType_int	static_QUType_int
#define static_TQUType_TQString	static_QUType_TQString
#define static_TQUType_ptr	static_QUType_ptr
#define static_TQUType_bool	static_QUType_bool
#define static_TQUType_varptr	static_QUType_varptr
#define static_TQUType_charstar	static_QUType_charstar

#define TQ_EXTERN_C		Q_EXTERN_C
#define TQ_EXPORT_PLUGIN	Q_EXPORT_PLUGIN
#define TQ_EXPORT		Q_EXPORT

#define tqreadBlock		readBlock
#define tqwriteBlock		writeBlock
#define TQT_TQIO_LONG		TQ_LONG
#define TQT_TQIO_ULONG		TQ_ULONG

#define tqt_mo_access access
#define tqt_mo_ci_name name
#define tqt_mo_ci_value value
#define tqt_mo_ci_count count
#define tqt_mo_ci_items items
#define tqt_mo_ci_method method

#define TQT_TQOBJECT(x) (static_cast<TQObject*>(static_cast<TQObject*>(x)))
#define TQT_TQWIDGET(x) (static_cast<TQWidget*>(static_cast<TQWidget*>(x)))
#define TQT_TQSIZEPOLICY(x) (static_cast<TQSizePolicy*>(static_cast<TQSizePolicy*>(x)))
#define TQT_TQLAYOUT(x) (static_cast<TQLayout*>(static_cast<TQLayout*>(x)))
#define TQT_TQGRIDLAYOUT(x) (static_cast<TQGridLayout*>(static_cast<TQGridLayout*>(x)))
#define TQT_TQPAINTER(x) (static_cast<TQPainter*>(static_cast<TQPainter*>(x)))
#define TQT_TQPAINTDEVICE(x) (static_cast<TQPaintDevice*>(static_cast<TQPaintDevice*>(x)))
#define TQT_TQLAYOUTITEM(x) (static_cast<TQLayoutItem*>(static_cast<TQLayoutItem*>(x)))
#define TQT_TQIODEVICE(x) (static_cast<TQIODevice*>(static_cast<TQIODevice*>(x)))
#define TQT_TQCOLOR(x) (static_cast<TQColor*>(static_cast<TQColor*>(x)))
#define TQT_TQCHAR(x) TQChar(x)
#define TQT_TQSTRING(x) TQString(x)
#define TQT_TQBUFFER(x) (static_cast<TQBuffer*>(static_cast<TQBuffer*>(x)))
#define TQT_TQWMATRIX(x) (static_cast<TQWMatrix*>(static_cast<TQMatrix*>(x)))
#define TQT_TQFILE(x) (static_cast<TQFile*>(static_cast<TQFile*>(x)))
#define TQT_TQBYTEARRAY(x) (static_cast<TQByteArray*>(static_cast<TQByteArray*>(x)))
#define TQT_TQMIMESOURCE(x) (static_cast<TQMimeSource*>(static_cast<TQMimeSource*>(x)))
#define TQT_TQWEXTRA(x) (static_cast<TQWExtra*>(static_cast<TQWExtra*>(x)))
#define TQT_TQPIXMAP(x) (static_cast<TQPixmap*>(static_cast<TQPixmap*>(x)))
#define TQT_TQCLIPBOARD(x) (static_cast<TQClipboard*>(static_cast<TQClipboard*>(x)))
#define TQT_TQPRINTER(x) (static_cast<TQPrinter*>(static_cast<TQPrinter*>(x)))
#define TQT_TQVARIANT(x) (static_cast<TQVariant*>(static_cast<TQVariant*>(x)))
#define TQT_TQMETAOBJECT(x) (static_cast<TQMetaObject*>(static_cast<TQMetaObject*>(x)))
#define TQT_TQSTYLEOPTION(x) (static_cast<TQStyleOption*>(static_cast<TQStyleOption*>(x)))
#define TQT_TQEVENT(x) (static_cast<TQEvent*>(static_cast<TQEvent*>(x)))
#define TQT_TQKEYEVENT(x) (static_cast<TQKeyEvent*>(static_cast<TQKeyEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQMOVEEVENT(x) (static_cast<TQMoveEvent*>(static_cast<TQMoveEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQSHOWEVENT(x) (static_cast<TQShowEvent*>(static_cast<TQShowEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQMOUSEEVENT(x) (static_cast<TQMouseEvent*>(static_cast<TQMouseEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQWHEELEVENT(x) (static_cast<TQWheelEvent*>(static_cast<TQWheelEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQFOCUSEVENT(x) (static_cast<TQFocusEvent*>(static_cast<TQFocusEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQPAINTEVENT(x) (static_cast<TQPaintEvent*>(static_cast<TQPaintEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCHILDEVENT(x) (static_cast<TQChildEvent*>(static_cast<TQChildEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCLOSEEVENT(x) (static_cast<TQCloseEvent*>(static_cast<TQCloseEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQTIMEREVENT(x) (static_cast<TQTimerEvent*>(static_cast<TQTimerEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQRESIZEEVENT(x) (static_cast<TQResizeEvent*>(static_cast<TQResizeEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQTABLETEVENT(x) (static_cast<TQTabletEvent*>(static_cast<TQTabletEvent*>(static_cast<TQEvent*>(x))))
#define TQT_TQCONTEXTMENUEVENT(x) (static_cast<TQContextMenuEvent*>(static_cast<TQContextMenuEvent*>(static_cast<TQEvent*>(x))))

#define TQT_TQOBJECT_OBJECT(x) x
#define TQT_TQSIZEPOLICY_OBJECT(x) x
#define TQT_TQLAYOUT_OBJECT(x) x
#define TQT_TQCOLOR_OBJECT(x) x
#define TQT_TQSTRING_OBJECT(x) x
#define TQT_TQSTRLIST_OBJECT(x) x
#define TQT_TQSTRINGLIST_OBJECT(x) x
#define TQT_TQWMATRIX_OBJECT(x) x
#define TQT_TQRECT_OBJECT(x) x
#define TQT_TQBYTEARRAY_OBJECT(x) x
#define TQT_TQPIXMAP_OBJECT(x) x
#define TQT_TQTIME_OBJECT(x) x
#define TQT_TQDATE_OBJECT(x) x
#define TQT_TQDATETIME_OBJECT(x) x
#define TQT_TQBRUSH_OBJECT(x) x
#define TQT_TQPALETTE_OBJECT(x) x
#define TQT_TQPOINT_OBJECT(x) x
#define TQT_TQREGION_OBJECT(x) x
#define TQT_TQIMAGE_OBJECT(x) x
#define TQT_TQPAINTDEVICE_OBJECT(x) x
#define TQT_TQVARIANT_OBJECT(x) x
#define TQT_TQIODEVICE_OBJECT(x) x
#define TQT_TQSTYLEOPTION_OBJECT(x) x

#define TQT_TQOBJECT_CONST(x) (static_cast<const TQObject*>(static_cast<const TQObject*>(x)))
#define TQT_TQWIDGET_CONST(x) (static_cast<const TQWidget*>(static_cast<const TQWidget*>(x)))
#define TQT_TQMIMESOURCE_CONST(x) (static_cast<const TQMimeSource*>(static_cast<const TQMimeSource*>(x)))
#define TQT_TQBRUSH_CONST(x) (static_cast<const TQBrush*>(static_cast<const TQBrush*>(x)))
#define TQT_TQPIXMAP_CONST(x) (static_cast<const TQPixmap*>(static_cast<const TQPixmap*>(x)))
#define TQT_TQPAINTDEVICE_CONST(x) (static_cast<const TQPaintDevice*>(static_cast<const TQPaintDevice*>(x)))
#define TQT_TQCOLOR_CONST(x) (static_cast<const TQColor*>(static_cast<const TQColor*>(x)))
#define TQT_TQPRINTER_CONST(x) (static_cast<const TQPrinter*>(static_cast<const TQPrinter*>(x)))
#define TQT_TQIODEVICE_CONST(x) (static_cast<const TQIODevice*>(static_cast<const TQIODevice*>(x)))
#define TQT_TQVARIANT_CONST(x) (static_cast<const TQVariant*>(static_cast<const TQVariant*>(x)))
#define TQT_TQMETAOBJECT_CONST(x) (static_cast<const TQMetaObject*>(static_cast<const TQMetaObject*>(x)))
#define TQT_TQSTYLEOPTION_CONST(x) (static_cast<const TQStyleOption*>(static_cast<const TQStyleOption*>(x)))

#define TQT_BASE_OBJECT_NAME TQObject
#define TQT_BASE_OBJECT(x) (static_cast<TQT_BASE_OBJECT_NAME*>(x))
#define TQT_BASE_OBJECT_CONST(x) (static_cast<const TQT_BASE_OBJECT_NAME*>(x))

#define setTqmaximumSize	setMaximumSize
#define setTqminimumSize	setMinimumSize
#define setTqalignment		setAlignment
#define setTqgeometry		setGeometry

#define tqarrowCursor		Qt::arrowCursor
#define tqupArrowCursor		Qt::upArrowCursor
#define tqcrossCursor		Qt::crossCursor
#define tqwaitCursor		Qt::waitCursor
#define tqibeamCursor		Qt::ibeamCursor
#define tqsizeVerCursor		Qt::sizeVerCursor
#define tqsizeHorCursor		Qt::sizeHorCursor
#define tqsizeBDiagCursor	Qt::sizeBDiagCursor
#define tqsizeFDiagCursor	Qt::sizeFDiagCursor
#define tqsizeAllCursor		Qt::sizeAllCursor
#define tqblankCursor		Qt::blankCursor
#define tqsplitVCursor		Qt::splitVCursor
#define tqsplitHCursor		Qt::splitHCursor
#define tqpointingHandCursor	Qt::pointingHandCursor
#define tqforbiddenCursor	Qt::forbiddenCursor
#define tqwhatsThisCursor	Qt::whatsThisCursor
#define tqbusyCursor		Qt::busyCursor

#define SET_QT_X_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_TIME(x)	get_tqt_x_time()
#define SET_QT_X_USER_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_USER_TIME(x)	get_tqt_x_time()

#endif /* TQT_VERSION_ONLY */

#endif /* TQT_H */
