#!/usr/bin/perl -w
use strict;
use blib;

package MyWidget;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);

use LCDRange;
use CannonField;

sub NEW {
    shift->SUPER::NEW(@_);

    my $quit = TQt::PushButton("&Quit", this, "quit");
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQT_SIGNAL('clicked()'), TQT_SLOT('quit()'));

    my $angle = LCDRange("ANGLE", this, "angle");
    $angle->setRange(5, 70);

    my $force = LCDRange("FORCE", this, "force");
    $force->setRange(10, 50);

    my $cannonField = CannonField(this, "cannonField");

    $cannonField->connect($angle, TQT_SIGNAL('valueChanged(int)'), TQT_SLOT('setAngle(int)'));
    $angle->connect($cannonField, TQT_SIGNAL('angleChanged(int)'), TQT_SLOT('setValue(int)'));

    $cannonField->connect($force, TQT_SIGNAL('valueChanged(int)'), TQT_SLOT('setForce(int)'));
    $force->connect($cannonField, TQT_SIGNAL('forceChanged(int)'), TQT_SLOT('setValue(int)'));

    my $shoot = TQt::PushButton('&Shoot', this, "shoot");
    $shoot->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    $cannonField->connect($shoot, TQT_SIGNAL('clicked()'), TQT_SLOT('shoot()'));

    my $grid = TQt::GridLayout(this, 2, 2, 10);
    $grid->addWidget($quit, 0, 0);
    $grid->addWidget($cannonField, 1, 1);
    $grid->setColStretch(1, 10);

    my $leftBox = TQt::VBoxLayout;
    $grid->addLayout($leftBox, 1, 0);
    $leftBox->addWidget($angle);
    $leftBox->addWidget($force);

    my $topBox = TQt::HBoxLayout;
    $grid->addLayout($topBox, 0, 1);
    $topBox->addWidget($shoot);
    $topBox->addStretch(1);

    $angle->setValue(60);
    $force->setValue(25);
    $angle->setFocus();
}

package main;
use TQt;
use MyWidget;

TQt::Application::setColorSpec(&TQt::Application::CustomColor);
my $a = TQt::Application(\@ARGV);

my $w = MyWidget;
$w->setGeometry(100, 100, 500, 355);
$a->setMainWidget($w);
$w->show;
exit $a->exec;
