###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for lcms #####

if( WITH_LCMS )
  pkg_search_module( LCMS lcms )
  if( NOT LCMS_FOUND )
    tde_message_fatal( "lcms was requested but was not found on your system" )
  endif()
endif( )


##### check for math libc #####

find_library( MATH_LIBC m )
if( NOT MATH_LIBC )
  tde_message_fatal( "libm is required but not found on your system" )
endif( )


##### check for zlib #####

pkg_search_module( ZLIB zlib )
if( NOT ZLIB_FOUND )
  tde_message_fatal( "zlib is required but not found on your system" )
endif( )


##### checks for dicom codec #####

if( BUILD_DICOM )
  ## check for medcon
  find_program( DICOM_COMMAND NAMES medcon )
  if( NOT DICOM_COMMAND )
    tde_message_fatal( "dicom codec was requested but medcon not found on your system" )
  endif( )
endif( )


##### checks for djvu codec #####

if( BUILD_DJVU )
  ## check for ddjvu
  find_program( DJVU_COMMAND NAMES ddjvu )
  if( NOT DJVU_COMMAND )
    tde_message_fatal( "djvu codec was requested but ddjvu not found on your system" )
  endif( )
endif( )


##### checks for dxf codec #####

if( BUILD_DXF )
  ## check for vec2web
  find_program( DXF_COMMAND NAMES vec2web )
  if( NOT DXF_COMMAND )
    tde_message_fatal( "dxf codec was requested but vec2web not found on your system" )
  endif( )
endif( )


##### checks for eps codec #####

if( BUILD_EPS )
  find_program( EPS_COMMAND NAMES gs )
  if( NOT EPS_COMMAND )
    tde_message_fatal( "eps codec was requested but gs not found on your system" )
  endif( )
endif( )


##### checks for fig codec #####

if( BUILD_FIG )
  ## check for fig2dev
  find_program( FIG2DEV_COMMAND NAMES fig2dev )
  if( NOT FIG2DEV_COMMAND )
    tde_message_fatal( "fig codec was requested but fig2dev not found on your system" )
  endif( )
endif( )


##### checks for gif codec #####

if( BUILD_GIF )
  find_package( GIF )
  if( NOT GIF_FOUND )
    tde_message_fatal( "libgif was requested but not found on your system." )
  endif( )
endif( )


##### checks for iff codec #####

if( BUILD_IFF )
  find_program( IFFTOPPM_COMMAND NAMES ilbmtoppm)
  if( NOT IFFTOPPM_COMMAND )
    tde_message_fatal( "iff codec was requested but ilbmtoppm not found on your system." )
  endif( )
endif( )


##### check for jpeg codec #####

if( BUILD_JPEG OR WITH_JPEG )
  find_package( JPEG )
  if( NOT JPEG_FOUND )
    tde_message_fatal( "libjpeg was requested but not found on your system" )
  endif()
endif()


##### checks for jpeg2000 codec #####

if( BUILD_JPEG2000 )
  find_package( Jasper )
  if( NOT JASPER_FOUND )
    tde_message_fatal( "libjasper was requested but not found on your system." )
  endif( )
  check_include_file( stdint.h HAVE_STDINT_H )
endif( )


##### check for leaf codec #####

if( BUILD_LEAF )
  find_program( LEAFTOPPM_COMMAND NAMES leaftoppm )
  if( NOT LEAFTOPPM_COMMAND )
    tde_message_fatal( "leaf codec was requested but leaftoppm not found on your system." )
  endif( )
endif( )


##### check for mac codec #####

if ( BUILD_MAC )
  find_program( MACPTOPPM_COMMAND NAMES macptopbm )
  if( NOT MACPTOPPM_COMMAND )
    tde_message_fatal( "mac codec was requested but macptopbm not found on your system." )
  endif( )
endif( )


##### checks for mng codec #####

if( BUILD_MNG )
  find_file( HAVE_LIBMNG_H "libmng.h" )
  if( NOT HAVE_LIBMNG_H )
    tde_message_fatal( "libmng was requested but not found on your system." )
  endif( )
  set( MNG_LIBRARY mng )
endif( )


##### check for neotoppm codec #####

if( BUILD_NEO )
  find_program( NEOTOPPM_COMMAND NAMES neotoppm )
  if( NOT NEOTOPPM_COMMAND )
    tde_message_fatal( "neo codec was requested but neotoppm not found on your system." )
  endif( )
endif( )


##### checks for openexr codec #####

if( BUILD_OPENEXR )
  pkg_search_module( OPENEXR OpenEXR )
  if( NOT OPENEXR_FOUND )
    tde_message_fatal( "libopenexr was requested but not found on your system." )
  endif( )
endif( )


##### check for pi1toppm codec #####

if( BUILD_PI1 )
  find_program( PI1TOPPM_COMMAND NAMES pi1toppm )
  if( NOT PI1TOPPM_COMMAND )
    tde_message_fatal( "pi1 codec was requested but pi1toppm not found on your system." )
  endif( )
endif( )


##### check for pi3toppm codec #####

if( BUILD_PI3 )
  find_program( PI3TOPPM_COMMAND NAMES pi3topbm )
  if( NOT PI3TOPPM_COMMAND )
    tde_message_fatal( "pi3 codec was requested but pi3topbm not found on your system." )
  endif( )
endif( )


##### check for picttoppm codec #####

if( BUILD_PICT )
  find_program( PICTTOPPM_COMMAND NAMES picttoppm )
  if( NOT PICTTOPPM_COMMAND )
    tde_message_fatal( "pict codec was requested but picttoppm not found on your system." )
  endif( )
endif( )


##### checks for svg codec #####

if( BUILD_SVG )
  find_program( RSVG_COMMAND NAMES "rsvg-convert" )
  if( NOT RSVG_COMMAND )
    tde_message_fatal( "svg codec was requested but rsvg-convert not found on your system" )
  endif( )
endif( )


##### checks for tiff codec #####

if( BUILD_TIFF )
  find_package( TIFF )
  if( NOT TIFF_FOUND )
    tde_message_fatal( "libtiff was requested but not found on your system" )
  endif( )
endif( )


##### checks for ttf codec #####

if( BUILD_TTF )
  pkg_search_module( FREETYPE freetype2 )
  if( NOT FREETYPE_FOUND )
    tde_message_fatal( "ttf codec was requested but freetype2 not found on your system." )
  endif( )
endif( )


##### check for utah codec #####

if( BUILD_UTAH )
  find_program( UTAHTOPPM_COMMAND NAMES rletopnm)
  if( NOT UTAHTOPPM_COMMAND )
    tde_message_fatal( "utah codec was requested but rletopnm not found on your system." )
  endif( )
endif( )


##### checks for wmf codec #####

if( BUILD_WMF )
  pkg_search_module( WMF libwmf )
  if( NOT WMF_FOUND )
    find_program( WMF_CONFIG_EXECUTABLE NAMES "libwmf-config" )

    if( WMF_CONFIG_EXECUTABLE )
      execute_process(
        COMMAND ${WMF_CONFIG_EXECUTABLE} --libs
        OUTPUT_VARIABLE WMF_LDFLAGS
        ERROR_VARIABLE WMF_LDFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
      )
      set( WMF_LIBRARIES "" )
      set( WMF_LIBRARY_DIRS "" )
      string( REPLACE " " ";" WMF_LDFLAGS ${WMF_LDFLAGS} )
      foreach( _ldflag IN LISTS WMF_LDFLAGS )
        if( _ldflag MATCHES "^-L" )
          string( REGEX REPLACE "^-L" "" _libdir "${_ldflag}" )
          list( APPEND WMF_LIBRARY_DIRS ${_libdir} )
        endif()
        if( _ldflag MATCHES "^-l" )
          string( REGEX REPLACE "^-l" "" _lib "${_ldflag}" )
          list( APPEND WMF_LIBRARIES ${_lib} )
        endif()
      endforeach()

      execute_process(
        COMMAND ${WMF_CONFIG_EXECUTABLE} --cflags
        OUTPUT_VARIABLE WMF_CFLAGS
        ERROR_VARIABLE WMF_CFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
      )
      set( WMF_INCLUDE_DIRS "" )
      string( REPLACE " " ";" WMF_CFLAGS ${WMF_CFLAGS} )
      foreach( _cflag IN LISTS WMF_CFLAGS )
        if( _cflag MATCHES "^-I" )
          string( REGEX REPLACE "^-I" "" _incdir "${_cflag}" )
          list( APPEND WMF_INCLUDE_DIRS ${_incdir} )
        endif()
      endforeach()

      set( WMF_FOUND 1 CACHE BOOL "WMF library found" FORCE )
      set( WMF_LIBRARIES "${WMF_LIBRARIES}" CACHE INTERNAL "WMF link libraries" )
      set( WMF_INCLUDE_DIRS "${WMF_INCLUDE_DIRS}" CACHE INTERNAL "WMF include directories" )
    endif( )
  endif( )
  if( NOT WMF_FOUND )
    tde_message_fatal( "libwmf was requested but not found on your system." )
  endif( )
endif( )


##### checks for xcf codec #####

if( BUILD_XCF )
  check_include_file( "inttypes.h" HAVE_INTTYPES_H )
  check_include_file( "netinet/in.h" HAVE_NETINET_IN_H )
  check_include_file( "arpa/inet.h" HAVE_ARPA_INET_H )
  check_include_file( "getopt.h" HAVE_GETOPT_H )
  check_function_exists( "getopt_long" HAVE_GETOPT_LONG )
  check_function_exists( "mmap" HAVE_MMAP )
  check_function_exists( "strcasecmp" HAVE_STRCASECMP )

  check_include_file( "iconv.h" HAVE_ICONV_H )
  if( NOT HAVE_ICONV_H )
    tde_message_fatal( "xcf codec was requested but iconv header not found on your system" )
  endif( )

  message( STATUS "Check for standalone libiconv" )
  find_library( HAVE_LIBICONV iconv )
  if( HAVE_LIBICONV )
    set( ICONV_LIBRARIES iconv )
    message( STATUS "Check for standalone libiconv - found" )
  else( )
    set( ICONV_LIBRARIES "" )
   message( STATUS "Check for standalone libiconv - not found" )
  endif( )

  tde_save_and_set( CMAKE_REQUIRED_LIBRARIES "${ICONV_LIBRARIES}" )
  check_function_exists( "iconv_open" HAVE_ICONV )
  tde_restore( CMAKE_REQUIRED_LIBRARIES )
  if( NOT HAVE_ICONV )
    tde_message_fatal( "xcf codec was requested but iconv library not found on your system" )
  endif()
endif( )


##### check for xim codec #####

if( BUILD_XIM )
  find_program( XIMTOPPM_COMMAND NAMES ximtoppm )
  if( NOT XIMTOPPM_COMMAND )
    tde_message_fatal( "xim codec was requested but ximtoppm not found on your system." )
  endif( )
endif( )


##### checks for xwd codec #####

if( BUILD_XWD )
  find_file( HAVE_XWDFILE_H "XWDFile.h" PATH_SUFFIXES "X11" )
  if( NOT HAVE_XWDFILE_H )
    tde_message_fatal( "xwd codec was requested but X11/XWDFile.h not found on your system" )
  endif( )
endif( )
