#include "kxsldbg.h"
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kdebug.h>

static const char *description =
    I18N_NOOP("A TDE KPart Application for xsldbg, an XSLT debugger");

static const char *version = VERSION;
static const TDECmdLineOptions options[] =
{
    { "+XSLSource", 	I18N_NOOP("XSL script to run"), 0},
    { "+XMLData",       I18N_NOOP("XML data to be transformed"), 0},
    { "+OutputFile",    I18N_NOOP("File to save results to"), 0},
    TDECmdLineLastOption // End of options.
};

int main(int argc, char **argv)
{
    TDEAboutData about("kxsldbg", I18N_NOOP("KXSLDbg"), version, description, TDEAboutData::License_GPL, "(C) 2003 Keith Isdale", 0, 0, "k_isdale@tpg.com.au");
    about.addAuthor( "Keith Isdale", 0, "k_isdale@tpg.com.au" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions( options );
    TDEApplication app;

    // see if we are starting with session management
    if (app.isRestored())
        RESTORE(KXsldbg)
    else
    {
        KXsldbg *widget = new KXsldbg;
        widget->show();
    }

    return app.exec();
}
