/***************************************************************************
                          kxmleditorfactory.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001, 2002, 2003 byThe KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#include "kxmleditorfactory.h"
#include "kxmleditorpart.h"
#include "kxmleditorabout.h"
#include "kxeconfiguration.h"
#include "kxedocument.h"

#include <kinstance.h>
#include <kdebug.h>

extern "C"
{
	TDE_EXPORT void * init_libkxmleditorpart()
	{
		return new KXMLEditorFactory;
	}
} 

TDEInstance * KXMLEditorFactory::s_instance = 0L;
KXEConfiguration * KXMLEditorFactory::s_pKXEConfig = 0L;

KXMLEditorFactory::KXMLEditorFactory( TQObject * pParent, const char * pszName )
	: KParts::Factory(pParent,pszName)
{
}

KXMLEditorFactory::~KXMLEditorFactory()
{
	if ( s_pKXEConfig )
		delete s_pKXEConfig;

	s_pKXEConfig = 0L;

	if (s_instance)
		delete s_instance;

	s_instance = 0L;
}

KParts::Part * KXMLEditorFactory::createPartObject( TQWidget * pParentWidget, const char * pszWidgetName, TQObject * pParent, const char * pszName, const char * pszClassName, const TQStringList & )
{
	// eliminating compiler warnings
	pParent = pParent;
	pszName = pszName;

	KParts::Part * pPart=0L;
	KXEDocument* pDocument=0L;
	if ( TQCString(pszClassName) == "KParts::ReadOnlyPart" )
	{
		pDocument = new KXEDocument();
		pPart = new KXMLEditorPart( false, pDocument, pParentWidget, pszWidgetName );
		kdDebug() << "KXMLEditorFactory::createPartObject: read only KXMLEditorPart created" << endl;
	}
	else if ( (TQCString(pszClassName) == "KParts::ReadWritePart") ||
	          (TQCString(pszClassName) == "KXMLEditorPart") )
	{
		pDocument = new KXEDocument();
		pPart = new KXMLEditorPart( true, pDocument, pParentWidget, pszWidgetName );
		kdDebug() << "KXMLEditorFactory::createPartObject: read/write KXMLEditorPart created" << endl;
	}
	else
	{
		kdError() << "KXMLEditorFactory::createPartObject: classname isn't KParts::ReadOnlyPart nor KParts::ReadWritePart." << endl;
		return 0L;
	}


	emit objectCreated( pPart );

	return pPart;
}

TDEInstance * KXMLEditorFactory::instance()
{
	if ( ! s_instance )
	{
		s_instance = new TDEInstance( new KXMLEditorAboutData() );
	}
	return s_instance;
}

KXEConfiguration * KXMLEditorFactory::configuration()
{
	if ( ! s_pKXEConfig )
		s_pKXEConfig = new KXEConfiguration();

	return s_pKXEConfig;
}

#include "kxmleditorfactory.moc"
