/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "colorcombo.h"

#include <kcolordialog.h>
#include <tdelocale.h>
#include <tqpainter.h>

bool ColorCombo::createdPalettes = false;
TQColor * ColorCombo::palette[ NumberOfSchemes ];
int ColorCombo::paletteSize[ NumberOfSchemes ];

ColorCombo::ColorCombo( ColorScheme colorScheme, TQWidget *parent, const char *name )
	: TQComboBox( parent, name )
{
	m_colorScheme = colorScheme;
	
	customColor.setRgb( 255, 255, 255 );
	internalColor.setRgb( 255, 255, 255 );

	createPalettes();

	addColors();

	connect( this, TQT_SIGNAL( activated(int) ), TQT_SLOT( slotActivated(int) ) );
	connect( this, TQT_SIGNAL( highlighted(int) ), TQT_SLOT( slotHighlighted(int) ) );
}


ColorCombo::~ColorCombo()
{
}


void ColorCombo::createPalettes()
{
	if ( createdPalettes )
		return;
	createdPalettes = true;
	
	paletteSize[ TQtStandard ] = 17;
	palette[ TQtStandard ] = new TQColor[ paletteSize[ TQtStandard ] ];

	int i = 0;

	palette[ TQtStandard ][i++] = TQt::red;
	palette[ TQtStandard ][i++] = TQt::green;
	palette[ TQtStandard ][i++] = TQt::blue;
	palette[ TQtStandard ][i++] = TQt::cyan;
	palette[ TQtStandard ][i++] = TQt::magenta;
	palette[ TQtStandard ][i++] = TQt::yellow;
	palette[ TQtStandard ][i++] = TQt::darkRed;
	palette[ TQtStandard ][i++] = TQt::darkGreen;
	palette[ TQtStandard ][i++] = TQt::darkBlue;
	palette[ TQtStandard ][i++] = TQt::darkCyan;
	palette[ TQtStandard ][i++] = TQt::darkMagenta;
	palette[ TQtStandard ][i++] = TQt::darkYellow;
	palette[ TQtStandard ][i++] = TQt::white;
	palette[ TQtStandard ][i++] = TQt::lightGray;
	palette[ TQtStandard ][i++] = TQt::gray;
	palette[ TQtStandard ][i++] = TQt::darkGray;
	palette[ TQtStandard ][i++] = TQt::black;
	
	
	paletteSize[ LED ] = 6;
	palette[ LED ] = new TQColor[ paletteSize[ LED ] ];
	
	i = 0;
	palette[ LED ][i++] = "#f62a2a";
	palette[ LED ][i++] = "#ff7733";
	palette[ LED ][i++] = "#ffbb33";
	palette[ LED ][i++] = "#eeee22";
	palette[ LED ][i++] = "#4cc308";
	palette[ LED ][i++] = "#22aaee";
}


void ColorCombo::setColor( const TQColor &col )
{
	internalColor = col;
	addColors();
}


void ColorCombo::resizeEvent( TQResizeEvent *re )
{
	TQComboBox::resizeEvent( re );
	addColors();
}


void ColorCombo::slotActivated( int index )
{
	if ( index == 0 )
	{
		if ( KColorDialog::getColor( customColor, this ) == TQDialog::Accepted )
		{
			TQPainter painter;
			TQPen pen;
			TQRect rect( 0, 0, width(), TQFontMetrics(painter.font()).height()+4);
			TQPixmap pixmap( rect.width(), rect.height() );

			if ( tqGray( customColor.rgb() ) < 128 )
				pen.setColor( white );
			else
				pen.setColor( black );

			painter.begin( &pixmap );
			TQBrush brush( customColor );
			painter.fillRect( rect, brush );
			painter.setPen( pen );
			painter.drawText( 2, TQFontMetrics(painter.font()).ascent()+2, i18n("Custom...") );
			painter.end();

			changeItem( pixmap, 0 );
			pixmap.detach();
		}

		internalColor = customColor;
	}
	else
		internalColor = palette[ m_colorScheme ][ index - 1 ];

	emit activated( internalColor );
}

void ColorCombo::slotHighlighted( int index )
{
	if ( index == 0 )
		internalColor = customColor;
	else
		internalColor = palette[ m_colorScheme ][ index - 1 ];

	emit highlighted( internalColor );
}

void ColorCombo::addColors()
{
	TQPainter painter;
	TQPen pen;
	TQRect rect( 0, 0, width(), TQFontMetrics(painter.font()).height()+4 );
	TQPixmap pixmap( rect.width(), rect.height() );
	int i;

	clear();

	createPalettes();

	for ( i = 0; i < paletteSize[ m_colorScheme ]; i++ )
		if ( palette[ m_colorScheme ][i] == internalColor ) break;

	if ( i == paletteSize[ m_colorScheme ] )
		customColor = internalColor;

	if ( tqGray( customColor.rgb() ) < 128 )
		pen.setColor( white );
	else
		pen.setColor( black );

	painter.begin( &pixmap );
	TQBrush brush( customColor );
	painter.fillRect( rect, brush );
	painter.setPen( pen );
	painter.drawText( 2, TQFontMetrics(painter.font()).ascent()+2, i18n("Custom...") );
	painter.end();

	insertItem( pixmap );
	pixmap.detach();

	for ( i = 0; i < paletteSize[ m_colorScheme ]; i++ )
	{
		painter.begin( &pixmap );
		TQBrush brush( palette[ m_colorScheme ][i] );
		painter.fillRect( rect, brush );
		painter.end();

		insertItem( pixmap );
		pixmap.detach();

		if ( palette[ m_colorScheme ][i] == internalColor )
			setCurrentItem( i + 1 );
	}
}


#include "colorcombo.moc"
