/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "eventinfo.h"
#include "itemdocument.h"
#include "itemview.h"


EventInfo::EventInfo()
{
	reset();
}


EventInfo::EventInfo( ItemView *itemView, TQEvent *e )
{
	Q_UNUSED(itemView);
	Q_UNUSED(e);
	reset();
}

EventInfo::EventInfo( ItemView *itemView, TQMouseEvent *e )
{
	pos = e->pos()/itemView->zoomLevel();
	globalPos = e->globalPos();
	isRightClick = e->button() == Qt::RightButton;
	ctrlPressed = e->state() & TQt::ControlButton;
	shiftPressed = e->state() & TQt::ShiftButton;
	altPressed = e->state() & TQt::AltButton;
	if ( ItemDocument * id = dynamic_cast<ItemDocument*>(itemView->document()) )
			qcanvasItemClickedOn = id->itemAtTop(pos);
	itemRtti = qcanvasItemClickedOn ? qcanvasItemClickedOn->rtti() : ItemDocument::RTTI::None;
	scrollDelta = 0;
	scrollOrientation = Qt::Vertical;
}


EventInfo::EventInfo( ItemView *itemView, TQWheelEvent *e )
{
	pos = e->pos()/itemView->zoomLevel();
	globalPos = e->globalPos();
	isRightClick = false;
	ctrlPressed = e->state() & TQt::ControlButton;
	shiftPressed = e->state() & TQt::ShiftButton;
	altPressed = e->state() & TQt::AltButton;
	if ( ItemDocument * id = dynamic_cast<ItemDocument*>(itemView->document()) )
		qcanvasItemClickedOn = id->itemAtTop(pos);
	itemRtti = qcanvasItemClickedOn ? qcanvasItemClickedOn->rtti() : ItemDocument::RTTI::None;
	scrollDelta = e->delta();
	scrollOrientation = e->orientation();
	
// 	kdDebug() << "scrollOrientation="<<scrollOrientation<<endl;
}


void EventInfo::reset()
{
	isRightClick = false;
	ctrlPressed = false;
	shiftPressed = false;
	altPressed = false;
	qcanvasItemClickedOn = 0l;
	itemRtti = ItemDocument::RTTI::None;
	scrollDelta = 0;
	scrollOrientation = Qt::Vertical;
}


TQMouseEvent *EventInfo::mousePressEvent( int dx, int dy ) const
{
	return new TQMouseEvent( TQEvent::MouseButtonPress,
							pos + TQPoint( dx, dy ),
							(isRightClick ? Qt::RightButton : Qt::LeftButton), 
							(isRightClick ? Qt::RightButton : Qt::LeftButton) |
									(ctrlPressed ? TQt::ControlButton : 0 ) |
									(shiftPressed ? TQt::ShiftButton : 0 ) |
									(altPressed ? TQt::AltButton : 0 ) );
}


TQMouseEvent *EventInfo::mouseReleaseEvent( int dx, int dy ) const
{
	return new TQMouseEvent( TQEvent::MouseButtonRelease,
							pos + TQPoint( dx, dy ),
							(isRightClick ? Qt::RightButton : Qt::LeftButton), 
							(isRightClick ? Qt::RightButton : Qt::LeftButton) |
									(ctrlPressed ? TQt::ControlButton : 0 ) |
									(shiftPressed ? TQt::ShiftButton : 0 ) |
									(altPressed ? TQt::AltButton : 0 ) );
}


TQMouseEvent *EventInfo::mouseDoubleClickEvent( int dx, int dy ) const
{
	return new TQMouseEvent( TQEvent::MouseButtonDblClick,
							pos + TQPoint( dx, dy ),
							(isRightClick ? Qt::RightButton : Qt::LeftButton), 
							(isRightClick ? Qt::RightButton : Qt::LeftButton) |
									(ctrlPressed ? TQt::ControlButton : 0 ) |
									(shiftPressed ? TQt::ShiftButton : 0 ) |
									(altPressed ? TQt::AltButton : 0 ) );
}


TQMouseEvent *EventInfo::mouseMoveEvent( int dx, int dy ) const
{
	return new TQMouseEvent( TQEvent::MouseMove,
							pos + TQPoint( dx, dy ),
							Qt::NoButton, 
							(ctrlPressed ? TQt::ControlButton : 0 ) |
									(shiftPressed ? TQt::ShiftButton : 0 ) |
									(altPressed ? TQt::AltButton : 0 ) );
}


TQWheelEvent *EventInfo::wheelEvent( int dx, int dy ) const
{
	return new TQWheelEvent( pos + TQPoint( dx, dy ),
							scrollDelta,
							(ctrlPressed ? TQt::ControlButton : 0 ) |
									(shiftPressed ? TQt::ShiftButton : 0 ) |
									(altPressed ? TQt::AltButton : 0 ),
							scrollOrientation );
}

