/***************************************************************************
                          qlcdstring.h  -  description
                             -------------------
    begin                : Sat Jul 21 2001
    copyright            : (C) 2001 by Michael
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TQLCDSTRING_H
#define TQLCDSTRING_H

#include <ntqframe.h>
#include <ntqpainter.h>
#include <ntqcolor.h>
#include <ntqstring.h>

#include "qlcddraw.h"

/**
  *@author Miguel Novas
  */

#include <ntqpalette.h>

class TQLCDString : public TQWidget  {
Q_OBJECT
public:

  enum Align {
                alignLeft   = 0x0000,
                alignCenter = 0x0001,
                alignRight  = 0x0002,
                alignJustify= 0x0003
             };

  TQLCDString( TQWidget *parent=0, const char *name=0 );
	~TQLCDString();

  void display( const TQString &str );

  void setShadow(bool enable);
  bool getShadow() { return (bool)(options & TQLcd::drawShadow); };

  void setAlign(Align newAlign);

  void setForeColor(const TQColor &fore);
  void setShadowColor(const TQColor &sha);

  void setNumberDisplay(bool enable);

  const TQColor& foreColor();
  const TQColor& shadowColor();

protected:

 void resizeEvent( TQResizeEvent *);
 void paintEvent ( TQPaintEvent *);

private:

  TQString   digitStr;
  int       options;

  TQColor forColor,shaColor;
};

#endif
