//
// C++ Interface: translitplugin
//
// Description: 
//
//
// Author: Dominik Seichter <domseichter@web.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TRANSLITPLUGIN_H
#define TRANSLITPLUGIN_H

#include "plugin.h"
#include "pluginloader.h"
#include "batchrenamer.h"

// QT includes
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtextcodec.h>
#include <tqvgroupbox.h>
#include <tqcheckbox.h>

// KDE includes
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kcombobox.h>
// #include <kdebug.h>

/**
@author Dominik Seichter
*/
class TranslitPlugin : public Plugin {
    TQ_OBJECT
  
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;
        const TQPixmap getIcon() const;
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void finished();
        bool checkError();
        void fillStructure();
        TQString processFile( BatchRenamer*, int, TQString token, int );
        TranslitPlugin();
    protected:
        TQString translit(const TQString &);

        typedef TQMap<TQString, TQString> TranslitMap;
        TranslitMap m_mapFromUTF8;
        
        static const TQString m_strUtf8[];
        static const TQString m_strEngl[];
};

#endif
