/***************************************************************************
                          kmylistbox.h  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYLISTBOX_H
#define KMYLISTBOX_H

// KDE includes
#include <tdelistbox.h>
#include <kurl.h>
#include <tdefileitem.h>

// TQt includes
#include <tqmutex.h>
#include <tqstringlist.h>

class ThreadedLister;

class KFileItem;
class KURLLabel;
class TQDragObject;
class TQPixmap;
class TQPainter;
class TQPoint;
class KMyListBox : public TDEListBox  {
    TQ_OBJECT
  
    public:
        enum { ASCENDING = 1, DESCENDING = 2, RANDOM = 3, NUMMERIC = 4, UNSORTED = 0 };

        KMyListBox(TQWidget* parent=0, const char* name=0, WFlags fl=0);
        ~KMyListBox();

        void removeItem( int index );
        void addDir( const KURL & dirname, const TQString & m_filter, bool m_hidden, bool recursively, bool dirnames = false );
        void addDirName( const KURL & dirname, const TQString & m_filter, bool m_hidden, bool recursive = false );
        void setPreview( bool prv );

        inline int sorting() const { return m_sorting; }
        
        void setName( bool name );

        void move( int i );
        void setPreviewSize( int size );
        inline int getPreviewSize() const { return previewSize; }

        KURL url( int index ) const;
        bool dir( int index ) const;

        bool isFile( const KURL & f, bool autoadd = true );
        void positionLabel();
        
        void clear();

        /**
         * returns the number of currently running ThreadedListers for adding files
         * or 0 if there is no file adding in progress right now.
         */
        unsigned int runningAddListeners();

    public slots:
        void moveMode();
        void moveDown();
        void moveDown( int i );
        void moveUp();
        void moveUp( int i );
        void setSorting( int s );

        void addFile( const KURL & filename, bool isfile = false );
        void addDirName( const KURL & dirname );

    signals:
        // emited when new item is drag'n'dropped into listobox
        // or when files are removed or something similar
        void updateCount();
        void updatePreview();
        void deletePressed();
        void addFiles();
        
        void currentlyAddingFiles();

    private:
        void preview( KURL::List list );

        void dropEvent( TQDropEvent* e );
        void dragEnterEvent( TQDragEnterEvent* e );
        void viewportMousePressEvent( TQMouseEvent* e );
        void viewportMouseReleaseEvent( TQMouseEvent* e );
        void viewportMouseMoveEvent( TQMouseEvent* e );
        void keyPressEvent( TQKeyEvent* e );
        void keyReleaseEvent( TQKeyEvent* e );

        bool isInList( KURL text );

        void sortAscending();
        void sortDescending();
        void sortUnsorted();
        void sortRandom();
        void sortNummeric();
        void sortList();
        void setButtonText();
    
        int compareNummeric( const TQString & s1, const TQString & s2 );
        const TQString findNumInString( unsigned int pos, const TQString & s );
        
    private slots:
        void openFile( TQListBoxItem* item );
        void select( TQListBoxItem* item );

        void previewDone( const KFileItem* item, const TQPixmap &pixmap );
        void previewFailed( const KFileItem* item );
        void previewFinished();

        void listerDone( ThreadedLister* lister );
        
    protected:
        void resizeEvent( TQResizeEvent* e );
        void customEvent( TQCustomEvent* e );
        void paintEvent( TQPaintEvent* e );                

        bool drag;
        bool mousePressed;
        bool ctrlPressed;
        bool shiftPressed;
        bool moving;
        int previewSize;
        int m_sorting;

        unsigned int m_running_lister_counter;
        TQMutex m_add_mutex;
        
        KURLLabel* label;

        TQDragObject* drobj;
        TQPoint presspos;
};

class KMyListBoxItem : public TQListBoxItem {
    public:
        KMyListBoxItem( const KMyListBoxItem* item );
        KMyListBoxItem( const KURL&, bool );

        bool hasPreview() const { return m_has_preview; }
        
        static void setName( bool b );
        static void setPreview( bool b );
        void setPixmap( const TQPixmap & pix );

        static bool preview() { return m_preview; }
        static bool name() { return m_name; }

        inline bool dir() const { return m_dir; }
        inline KURL url() const { return m_url; }
        inline const TQPixmap* pixmap() const { return &pm; }

    private:
        TQString text() const;

    protected:
        virtual void paint( TQPainter *painter );
        virtual int width( const TQListBox* ) const;
        virtual int height( const TQListBox* lb ) const;

    private:
        KURL m_url;
        bool m_dir;
        bool m_has_preview;
        TQPixmap pm;

        static bool m_preview;
        static bool m_name;
};

#endif
