/***************************************************************************
*   Copyright (C) 2005 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef INGREDIENTCOMBOBOX_H
#define INGREDIENTCOMBOBOX_H

#include <kcombobox.h>

#include <tqmap.h>

#include "datablocks/element.h"

class TQTimer;

class RecipeDB;
class ElementList;

class IngredientComboBox : public KComboBox
{
	TQ_OBJECT

public:
	IngredientComboBox( bool, TQWidget *parent, RecipeDB *db, const TQString &specialItem = TQString::null );

	void reload();
	int id( int row );
	int id( const TQString &ing );

	void startLoad();
	void endLoad();

private slots:
	void createIngredient( const Element &element );
	void removeIngredient( int id );

	int findInsertionPoint( const TQString &name );
	void loadMore();

private:
	RecipeDB *database;
	TQMap<int, int> ingredientComboRows; // Contains the category id for every given row in the category combobox

	int loading_at;
	int ing_count;
	int load_limit;
	TQTimer *load_timer;
	TQString m_specialItem;
};

#endif //INGREDIENTCOMBOBOX_H

