/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "dbimportdialog.h"

#include <unistd.h> //for getuid()
#include <pwd.h> //getpwuid()

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqpushbutton.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqwidgetstack.h>
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <tqhbox.h>

#include <tdeconfig.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <knuminput.h>

DBImportDialog::DBImportDialog( TQWidget *parent, const char *name )
		: KDialogBase( parent, name, true, i18n( "Database Import" ),
		    KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok )
{
	setButtonBoxOrientation( Vertical );

	TQHBox *page = makeHBoxMainWidget();

	dbButtonGroup = new TQButtonGroup( page, "dbButtonGroup" );
	dbButtonGroup->setSizePolicy( TQSizePolicy( ( TQSizePolicy::SizeType ) 4, ( TQSizePolicy::SizeType ) 5, 0, 0, dbButtonGroup->sizePolicy().hasHeightForWidth() ) );
	dbButtonGroup->setColumnLayout( 0, TQt::Vertical );
	dbButtonGroup->layout() ->setSpacing( 6 );
	dbButtonGroup->layout() ->setMargin( 11 );
	dbButtonGroupLayout = new TQVBoxLayout( dbButtonGroup->layout() );
	dbButtonGroupLayout->setAlignment( TQt::AlignTop );

	liteRadioButton = new TQRadioButton( dbButtonGroup, "liteRadioButton" );
	liteRadioButton->setChecked( TRUE );
	dbButtonGroupLayout->addWidget( liteRadioButton );

	mysqlRadioButton = new TQRadioButton( dbButtonGroup, "mysqlRadioButton" );
	dbButtonGroupLayout->addWidget( mysqlRadioButton );

	psqlRadioButton = new TQRadioButton( dbButtonGroup, "psqlRadioButton" );
	dbButtonGroupLayout->addWidget( psqlRadioButton );

	paramStack = new TQWidgetStack( page, "paramStack" );
	paramStack->setSizePolicy( TQSizePolicy( ( TQSizePolicy::SizeType ) 7, ( TQSizePolicy::SizeType ) 5, 0, 0, paramStack->sizePolicy().hasHeightForWidth() ) );

	sqlitePage = new TQWidget( paramStack, "sqlitePage" );
	serverPageLayout_2 = new TQVBoxLayout( sqlitePage, 11, 6, "serverPageLayout_2" );

	TQLabel *sqliteLabel = new TQLabel( i18n( "Database file:" ), sqlitePage );
	serverPageLayout_2->addWidget( sqliteLabel );
	sqliteDBRequester = new KURLRequester( sqlitePage, "sqliteDBRequester" );
	sqliteDBRequester->setShowLocalProtocol( false );
	serverPageLayout_2->addWidget( sqliteDBRequester );

	TQSpacerItem *vSpacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
	serverPageLayout_2->addItem(vSpacer);

	paramStack->addWidget( sqlitePage, 1 );

	serverPage = new TQWidget( paramStack, "serverPage" );
	serverPageLayout = new TQVBoxLayout( serverPage, 11, 6, "serverPageLayout" );

	layout5 = new TQGridLayout( 0, 1, 1, 0, 6, "layout5" );

	hostEdit = new TQLineEdit( serverPage, "hostEdit" );
	layout5->addWidget( hostEdit, 0, 1 );
	hostLabel = new TQLabel( serverPage, "hostLabel" );
	layout5->addWidget( hostLabel, 0, 0 );

	userEdit = new TQLineEdit( serverPage, "userEdit" );
	layout5->addWidget( userEdit, 1, 1 );
	userLabel = new TQLabel( serverPage, "userLabel" );
	layout5->addWidget( userLabel, 1, 0 );

	passwordEdit = new TQLineEdit( serverPage, "passwordEdit" );
	passwordEdit->setEchoMode( TQLineEdit::Password );
	layout5->addWidget( passwordEdit, 2, 1 );
	passwordLabel = new TQLabel( serverPage, "passwordLabel" );
	layout5->addWidget( passwordLabel, 2, 0 );

	portEdit = new KIntNumInput( serverPage, "portEdit" );
	portEdit->setMinValue(0);
	portEdit->setValue(0);
	layout5->addWidget( portEdit, 3, 1 );
	portLabel = new TQLabel( serverPage, "portLabel" );
	layout5->addWidget( portLabel, 3, 0 );

	nameEdit = new TQLineEdit( serverPage, "nameEdit" );
	layout5->addWidget( nameEdit, 4, 1 );
	nameLabel = new TQLabel( serverPage, "nameLabel" );
	layout5->addWidget( nameLabel, 4, 0 );

	serverPageLayout->addLayout( layout5 );
	paramStack->addWidget( serverPage, 0 );

	languageChange();


#if (!HAVE_MYSQL)

	mysqlRadioButton->setEnabled( false );
#endif

#if (!HAVE_POSTGRESQL)

	psqlRadioButton->setEnabled( false );
#endif

#if (!(HAVE_SQLITE || HAVE_SQLITE3))

	liteRadioButton->setEnabled( false );
#if (HAVE_MYSQL)

	dbButtonGroup->setButton( 1 ); // Otherwise by default liteCheckBox is checked even if it's disabled
	switchDBPage(1);
#else
	#if (HAVE_POSTGRESQL)

	dbButtonGroup->setButton( 2 );
	switchDBPage(2);
#endif
	#endif
	#endif

	// signals and slots connections
	connect( dbButtonGroup, TQ_SIGNAL( clicked( int ) ), this, TQ_SLOT( switchDBPage( int ) ) );
}

void DBImportDialog::languageChange()
{
	dbButtonGroup->setTitle( i18n( "Database" ) );
	liteRadioButton->setText( "SQLite" );
	mysqlRadioButton->setText( "MySQL" );
	psqlRadioButton->setText( "PostgreSQL" );
	hostLabel->setText( i18n( "Server:" ) );
	userLabel->setText( i18n( "Username:" ) );
	passwordLabel->setText( i18n( "Password:" ) );
	nameLabel->setText( i18n( "Database name:" ) );
	portLabel->setText( i18n( "Port:" ) );
	portEdit->setSpecialValueText( i18n("Default") );

	//set defaults
	hostEdit->setText( "localhost" );
	nameEdit->setText( "Krecipes" );

	// get username
	uid_t userID;
	struct passwd *user;
	userID = getuid();
	user = getpwuid ( userID );
	TQString username(user->pw_name);

	userEdit->setText( username );
}

void DBImportDialog::switchDBPage( int id )
{
	switch ( id ) {
	case 0:  //SQLite
		paramStack->raiseWidget( sqlitePage );
		break;
	case 1:  //MySQL
	case 2:  //PostgreSQL
		paramStack->raiseWidget( serverPage );
		break;
	}
}

TQString DBImportDialog::dbType() const
{
	int id = dbButtonGroup->id( dbButtonGroup->selected() );
	switch ( id ) {
	case 0:
		return "SQLite";
	case 1:
		return "MySQL";
	case 2:
		return "PostgreSQL";
	default:
		return TQString::null;
	}
}

void DBImportDialog::serverParams( TQString &host, TQString &user, TQString &pass, int &port, TQString &table ) const
{
	host = hostEdit->text();
	user = userEdit->text();
	pass = passwordEdit->text();
	table = nameEdit->text();
	port = portEdit->value();
}

TQString DBImportDialog::dbFile() const
{
	return sqliteDBRequester->url();
}

#include "dbimportdialog.moc"
