/***************************************************************************
 *   Copyright (C) 2005 by Mark Six                                        *
 *   marksix@xs4all.nl                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KSERIALVIEW_H
#define KSERIALVIEW_H

#include <tdetoolbar.h>
#include <ktextedit.h>
#include <klineedit.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqfont.h>
#include <tqpopupmenu.h>

#include "kport.h"

class KSerialWindow : public KTextEdit 
{
	Q_OBJECT
  
	
	public:
		KSerialWindow( TQWidget *parent ) : KTextEdit( parent ) {
			setWrapColumnOrWidth( 80 ) ; 				// Serial window is a terminal
			setWrapPolicy( TQTextEdit::Anywhere ) ;
			setWordWrap( TQTextEdit::FixedColumnWidth ) ; 
			setFont( TDEGlobalSettings::fixedFont()  ) ;  // Use default fixed font
		}
		virtual ~KSerialWindow() {} ;
		
	protected:
		virtual void keyPressEvent( TQKeyEvent *e ) 
		{ 
			emit keyPressed( e->ascii() ) ; 
		}
		
		virtual void mousePressEvent( TQMouseEvent *e ) {
		}
		virtual void mouseReleaseEvent( TQMouseEvent *e ) {}
		virtual TQPopupMenu *createPopupMenu( const TQPoint &pos ) 
		{ 
			TQPopupMenu *menu = new TQPopupMenu( this ) ;
			menu->insertItem( "clear view", this, TQT_SLOT( clearView() ) ) ;
			return menu ; 
		}
	public slots:
		void clearView() {
			clear() ;
		}

	signals:
		void keyPressed( int key ) ;
	
} ;

class KSerialView : public TQWidget
{
	Q_OBJECT
  
	public:
    	KSerialView( CPicoBlaze *cpu, TQWidget *parent );
	    ~KSerialView();
	
		KPort * rxPort, * txPort, * statusPort ;
		
	public slots:
		void transmit( unsigned char ) ;
		void receive() ;
		void keyPressed( int key ) ;
	
	protected:
		KSerialWindow *view ;
		
		unsigned char rxFifo[ 16 ] ;
		unsigned char fifoPtr ;		
		
		unsigned char getReceiveFlags() ;
		unsigned char getTransmitFlags() ;
		void setStatusBits( unsigned char ) ;
		
		CPicoBlaze * m_cpu ;

		KLineEdit *txPortID, *rxPortID, *statusPortID ;
		TQCheckBox *m_statusBits[ 8 ] ;

		TQColor m_backgroundColor ;
		TQPushButton *m_clearButton ;

	public slots:
		void updateTxId( const TQString & ) ; 
		void updateRxId( const TQString & ) ;
		void updateStatusId( const TQString & ) ;
		void txFlagsChanged( bool en ) ;
};

#endif
