/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2004 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#ifndef COMMON_H
#define COMMON_H

class TQCString;
class TQString;
class TQBitmap;
class TQPixmap;

namespace Konversation
{
    TQString removeIrcMarkup(const TQString& text);
    TQString tagURLs(const TQString& text, const TQString& fromNick, bool useCustomColor = true);
    TQBitmap overlayMasks( const TQBitmap *under, const TQBitmap *over );
    TQPixmap overlayPixmaps(const TQPixmap &under, const TQPixmap &over);
    bool isUtf8(const TQCString& text);

    enum TabNotifyType
    {
        tnfNick,
        tnfHighlight,
        tnfPrivate,
        tnfNormal,
        tnfSystem,
        tnfControl,
        tnfNone
    };

    enum ConnectionState
    {
        SSNeverConnected,
        SSDeliberatelyDisconnected,
        SSInvoluntarilyDisconnected,
        SSConnecting,
        SSConnected
    };

    enum ConnectionFlag 
    {
        SilentlyReuseConnection,
        PromptToReuseConnection,
        CreateNewConnection
    };
}
#endif
