#ifndef IRCVIEW_H
#define IRCVIEW_H

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2005-2006 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#include "common.h"

#include <tqmap.h>
#include <tqfontdatabase.h>

#include <ktextbrowser.h>


class TQPixmap;
class TQStrList;
class TQDropEvent;
class TQDragEnterEvent;
class TQEvent;

class TDEPopupMenu;

class Server;
class ChatWindow;
class SearchBar;

class IRCView : public KTextBrowser
{
    Q_OBJECT
  

    public:
        IRCView(TQWidget* parent,Server* newServer);
        ~IRCView();

        void clear();
        void setViewBackground(const TQColor& backgroundColor, const TQString& pixmapName);
        void setServer(Server* server);

        // Returns the current nick under context menu.
        const TQString& getContextNick() const;

        void enableParagraphSpacing();

        TQPopupMenu* getPopup() const;

        enum PopupIDs
        {
            Copy,CopyUrl,SelectAll,
            Search,
            SendFile,
            Bookmark,
            SaveAs
        };

        void setChatWin(ChatWindow* chatWin);

        bool search(const TQString& pattern, bool caseSensitive,
            bool wholeWords, bool forward, bool fromCursor);
        bool searchNext(bool reversed = false);

        TQColor highlightColor() { return m_highlightColor; }
        TQString currentChannel() { return m_currentChannel; }

        void setNickAndChannelContextMenusEnabled(bool enable);

        bool hasLines();


    signals:
        // Notify container of new text and highlight state
        void gotFocus();                          // So we can set focus to input line
        void textToLog(const TQString& text);
        void sendFile();
        void extendedPopup(int id);
        void autoText(const TQString& text);
        void textPasted(bool useSelection);
        void popupCommand(int);
        void filesDropped(const TQStrList&);
        void doSearch();

        void setStatusBarTempText(const TQString&);
        void clearStatusBarTempText();

    public slots:
        void insertRememberLine();
        void cancelRememberLine();
        void insertMarkerLine();
        void clearLines();

        void append(const TQString& nick, const TQString& message);
        void appendRaw(const TQString& message, bool suppressTimestamps=false, bool self = false);
        void appendQuery(const TQString& nick, const TQString& message, bool inChannel = false);
        void appendQueryAction(const TQString& nick, const TQString& message);
        void appendChannelAction(const TQString& nick, const TQString& message);
        void appendServerMessage(const TQString& type, const TQString& message, bool parseURL = true);
        void appendCommandMessage(const TQString& command, const TQString& message, bool important,
            bool parseURL=true, bool self=false);
        void appendBacklogMessage(const TQString& firstColumn, const TQString& message);
        void search();
        void searchAgain();

        void setCurrentChannel(const TQString& channel) { m_currentChannel = channel; }

        virtual void removeSelectedText(int selNum=0);

        virtual void scrollToBottom();            // Overwritten for internal reasons

        // Clears context nick
        void clearContextNick();

        // Updates the scrollbar position
        void updateScrollBarPos();

	// Override ensureCursorVisible() to have an ability to disable this call
	virtual void ensureCursorVisible();

    protected slots:
        void highlightedSlot(const TQString& link);
        void saveLinkAs(const TQString& url);

    protected:
        void openLink(const TQString &url, bool newTab=false);
        TQString filter(const TQString& line, const TQString& defaultColor, const TQString& who=NULL,
        bool doHighlight=true, bool parseURL=true, bool self=false);
        void appendAction(const TQString& nick, const TQString& message);
        void doAppend(const TQString& line, bool self=false);
        void replaceDecoration(TQString& line,char decoration,char replacement);
        virtual void contentsDragMoveEvent(TQDragMoveEvent* e);
        virtual void contentsDropEvent(TQDropEvent* e);
        virtual void contentsMouseReleaseEvent(TQMouseEvent* ev);
        virtual void contentsMousePressEvent(TQMouseEvent* ev);
        virtual void contentsMouseMoveEvent(TQMouseEvent* ev);
        virtual void contentsContextMenuEvent(TQContextMenuEvent* ev);

        virtual void keyPressEvent(TQKeyEvent* e);
        virtual void resizeEvent(TQResizeEvent* e);

        void hideEvent(TQHideEvent* event);
        void showEvent(TQShowEvent* event);
        void paintEvent(TQPaintEvent* event);

        bool contextMenu(TQContextMenuEvent* ce);

        void setupNickPopupMenu();
        void updateNickMenuEntries(TQPopupMenu* popup, const TQString& nickname);
        void setupQueryPopupMenu();
        void setupChannelPopupMenu();

        TQChar::Direction basicDirection(const TQString &string);

        /// Returns a formated timestamp if timestamps are enabled else it returns TQString()
        TQString timeStamp();

        /// Returns a formated nick string
        TQString createNickLine(const TQString& nick, bool encapsulateNick = true, bool privMsg = false);

        // used by search function
        int m_findParagraph;
        int m_findIndex;

        void appendLine(const TQString& color);
        void appendRememberLine();

        void updateLineParagraphs(int numRemoved);
        void wipeLineParagraphs();

        int m_rememberLineParagraph;
        bool m_rememberLineDirtyBit;

        TQValueList<int> m_markerLineParagraphs;

        // This is set to what we last sent status text to the statusbar.  Empty if we have sent clearStatusBarTempText() string
        TQString m_lastStatusText;
        // decide if we should place the scrollbar at the bottom on show()
        bool m_resetScrollbar;

        TQString m_autoTextToSend;
        Konversation::TabNotifyType m_tabNotification;
        bool m_copyUrlMenu;
        TQString m_urlToCopy;

        TQString m_buffer;
        Server* m_server;
        TQPopupMenu* m_popup;
        int toggleMenuBarSeparator;
        int copyUrlMenuSeparator;
        TDEPopupMenu* m_nickPopup;
        TDEPopupMenu* m_channelPopup;
        TDEPopupMenu* m_modes;
        TDEPopupMenu* m_kickban;

        static TQChar LRM;
        static TQChar RLM;
        static TQChar LRE;
        static TQChar RLE;
        static TQChar RLO;
        static TQChar LRO;
        static TQChar PDF;

        bool m_caseSensitive;
        bool m_wholeWords;
        bool m_forward;
        bool m_fromCursor;
        TQString m_pattern;
        TQColor m_highlightColor;

        uint m_offset;
        TQStringList m_colorList;

        TQString m_highlightedURL;   // the URL we're currently hovering on with the mouse
        TQString m_currentNick;
        TQString m_currentChannel;
        bool m_isOnNick;
        bool m_isOnChannel;
        bool m_mousePressed;
        TQString m_urlToDrag;
        TQPoint m_pressPosition;
        int m_nickPopupId;
        int m_channelPopupId;

        TQFontDatabase m_fontDataBase;
	
	// Provide ability to disable parent ensureCursorVisible() call
	bool m_disableEnsureCursorVisible;
	// If this widget was painted at least once. Needed for scrollbar
	// reset HACK as a precaution.
	bool m_wasPainted;

        ChatWindow* m_chatWin;
        friend class IRCStyleSheet;
};
#endif
