/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Shows the list of channels
  begin:     Die Apr 29 2003
  copyright: (C) 2003 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef CHANNELLISTPANEL_H
#define CHANNELLISTPANEL_H

#include "chatwindow.h"

#include <tqtimer.h>


class TQCheckBox;
class TQStringList;
class TQTimer;
class TQListView;
class TQListViewItem;
class TQPushButton;

class TDEListView;
class KLineEdit;
class ChannelListViewItem;

class ChannelListPanel : public ChatWindow
{
    Q_OBJECT
  

    public:
        explicit ChannelListPanel(TQWidget* parent);
        ~ChannelListPanel();

        virtual bool closeYourself();
        virtual void emitUpdateInfo();

    signals:
        void refreshChannelList();
        void joinChannel(const TQString& channelName);
        void adjustMinValue(int num);
        void adjustMaxValue(int num);
        void updateNumUsers(const TQString& num);
        void updateNumChannels(const TQString& num);

    public slots:
        void addToChannelList(const TQString& channel,int users,const TQString& topic);

        virtual void appendInputText(const TQString&, bool fromCursor);
        void setFilter(const TQString& filter);

        void applyFilterClicked();

    protected slots:
        void refreshList();
        void updateDisplay();                     // will be called by a timer to update regularly
        void saveList();
        void joinChannelClicked();

        void setMinUsers(int num);
        void setMaxUsers(int num);

        void filterTextChanged(const TQString& newText);
        void channelTargetClicked();
        void topicTargetClicked();
        void regExpClicked();

        void contextMenu (TDEListView* l, TQListViewItem* i, const TQPoint& p);

        //Used to disable functions when not connected
        virtual void serverOnline(bool online);

    protected:

        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        virtual bool isInsertCharacterSupported() { return true; }

        int getNumChannels();
        int getNumUsers();
        int getVisibleChannels();
        int getVisibleUsers();

        void setNumChannels(int num);
        void setNumUsers(int num);
        void setVisibleChannels(int num);
        void setVisibleUsers(int num);

        void setChannelTarget(bool state);
        bool getChannelTarget();

        void setTopicTarget(bool state);
        bool getTopicTarget();

        void setRegExp(bool state);
        bool getRegExp();

        int getMinUsers();
        int getMaxUsers();

        const TQString& getFilterText();
        void  applyFilterToItem(TQListViewItem* item);

        void updateUsersChannels();

        int numChannels;
        int numUsers;
        int visibleChannels;
        int visibleUsers;

        int minUsers;
        int maxUsers;

        bool channelTarget;
        bool topicTarget;

        bool regExp;

        // store channels to be inserted in ListView here first
        TQStringList pendingChannels;
        TQTimer updateTimer;

        TQCheckBox* channelFilter;
        TQCheckBox* topicFilter;
        TQCheckBox* regexpCheck;

        TQPushButton* applyFilter;
        TQPushButton* refreshListButton;
        TQPushButton* joinChannelButton;

        TDEListView* channelListView;

        KLineEdit* filterInput;

        TQString filterText;

        int m_oldSortColumn;
};
#endif
