/* This file is part of the KDE project
   Copyright (C) 2000 Robert JACOLIN <rjacolin@ifrance.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __XSLTIMPORTDIA_H__
#define __XSLTIMPORTDIA_H__

#include "tdeapplication.h"
#include <tdefiledialog.h>
#include <KoStore.h>
#include "xsltdialog.h"

class XSLTImportDia : public XSLTDialog
{
    TQ_OBJECT
  

	TQString _fileIn;
	TQString _fileOut;
	TQByteArray _arrayIn;
	KoStore* _out;
	/** xslt file current */
	KURL _currentFile;
	TQCString _format;
	TDEConfig* _config;
	/** List of the most recent xslt file used. */
	TQStringList _recentList;

	/** Lits use for common xslt files. */
	TQStringList _dirsList;
	TQStringList _filesList;
	TQStringList _namesList;

public:
    XSLTImportDia(KoStore*, const TQCString &format, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~XSLTImportDia();

	void setInputFile(TQString file)  { _fileIn = file; }
	void setOutputFile(TQString file) { _fileOut = file; }

public slots:
    virtual void cancelSlot();
    virtual void chooseSlot();
	virtual void chooseRecentSlot();
	virtual void chooseCommonSlot();
    virtual void okSlot();

};

#endif /* __XSLTIMPORTDIA_H__ */
