/* This file is part of the KDE project
   Copyright (C) 2004 Peter Simonsson <psn@linux.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KoSelectAction.h"

#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqwhatsthis.h>
#include <tqmenubar.h>

#include <tdepopupmenu.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdetoolbar.h>
#include <tdetoolbarbutton.h>
#include <kiconloader.h>
#include <tdelocale.h>

class KoSelectAction::KoSelectActionPrivate
{
  public:
    KoSelectActionPrivate()
    {
      m_popup = new TDEPopupMenu(0L,"KoLineStyleAction::popup");
      m_currentSelection = 0;
    }
    
    ~KoSelectActionPrivate()
    {
      delete m_popup;
      m_popup = 0;
    }
    
    TDEPopupMenu* m_popup;
    int m_currentSelection;
};

KoSelectAction::KoSelectAction(const TQString &text, const TQString& icon,
  TQObject* parent, const char* name) : TDEAction(text, icon, 0, parent, name)
{
  d = new KoSelectActionPrivate;
  setShowCurrentSelection(true);
  
  connect(popupMenu(), TQT_SIGNAL(activated(int)), this, TQT_SLOT(execute(int)));
}

KoSelectAction::KoSelectAction(const TQString &text, const TQString& icon, const TQObject* receiver,
  const char* slot, TQObject* parent, const char* name) : TDEAction(text, icon, 0, parent, name)
{
  d = new KoSelectActionPrivate;
  
  connect(this, TQT_SIGNAL(selectionChanged(int)), receiver, slot);
  connect(popupMenu(), TQT_SIGNAL(activated(int)), this, TQT_SLOT(execute(int)));
}

KoSelectAction::~KoSelectAction()
{
  delete d;
}

TDEPopupMenu* KoSelectAction::popupMenu() const
{
  return d->m_popup;
}

void KoSelectAction::popup(const TQPoint& global)
{
  popupMenu()->popup(global);
}

int KoSelectAction::plug(TQWidget* widget, int index)
{
  // This function is copied from TDEActionMenu::plug
  if (kapp && !kapp->authorizeTDEAction(name()))
    return -1;
  kdDebug(129) << "TDEAction::plug( " << widget << ", " << index << " )" << endl; // remove -- ellis
  if ( widget->inherits(TQPOPUPMENU_OBJECT_NAME_STRING) )
  {
    TQPopupMenu* menu = static_cast<TQPopupMenu*>( widget );
    int id;

    if ( hasIconSet() )
      id = menu->insertItem( iconSet(), text(), popupMenu(), -1, index );
    else
      id = menu->insertItem( kapp->iconLoader()->loadIcon(icon(), TDEIcon::Small),
        text(), popupMenu(), -1, index );

    if ( !isEnabled() )
      menu->setItemEnabled( id, false );

    addContainer( menu, id );
    connect( menu, TQT_SIGNAL( destroyed() ), this, TQT_SLOT( slotDestroyed() ) );

    return containerCount() - 1;
  }
  else if ( widget->inherits( "TDEToolBar" ) )
  {
    TDEToolBar *bar = static_cast<TDEToolBar *>( widget );

    int id_ = TDEAction::getToolButtonID();

    if ( icon().isEmpty() && !iconSet().isNull() ) {
      bar->insertButton( iconSet().pixmap(), id_, TQT_SIGNAL( clicked() ), this,
                          TQT_SLOT( slotActivated() ), isEnabled(), plainText(),
                          index );
    } else {
      TDEInstance *instance;

      if ( m_parentCollection ) {
        instance = m_parentCollection->instance();
      } else {
        instance = TDEGlobal::instance();
      }

      bar->insertButton( icon(), id_, TQT_SIGNAL( clicked() ), this,
                          TQT_SLOT( slotActivated() ), isEnabled(), plainText(),
                          index, instance );
    }

    addContainer( bar, id_ );

    if (!whatsThis().isEmpty())
      TQWhatsThis::add( bar->getButton(id_), whatsThis() );

    connect( bar, TQT_SIGNAL( destroyed() ), this, TQT_SLOT( slotDestroyed() ) );

    bar->getButton(id_)->setPopup(popupMenu(), true );

    return containerCount() - 1;
  }
  else if ( widget->inherits( TQMENUBAR_OBJECT_NAME_STRING ) )
  {
    TQMenuBar *bar = static_cast<TQMenuBar *>( widget );

    int id;

    id = bar->insertItem( text(), popupMenu(), -1, index );

    if ( !isEnabled() )
      bar->setItemEnabled( id, false );

    addContainer( bar, id );
    connect( bar, TQT_SIGNAL( destroyed() ), this, TQT_SLOT( slotDestroyed() ) );

    return containerCount() - 1;
  }

  return -1;
}

void KoSelectAction::execute(int index)
{
  setCurrentSelection(index);
  emit selectionChanged(d->m_currentSelection);
}

int KoSelectAction::currentSelection()
{
  return d->m_currentSelection;
}

void KoSelectAction::setCurrentSelection(int index)
{
  if(popupMenu()->isCheckable()) {
    popupMenu()->setItemChecked(d->m_currentSelection, false);
    popupMenu()->setItemChecked(index, true);
  }

  d->m_currentSelection = index;
}

void KoSelectAction::setShowCurrentSelection(bool show)
{
  popupMenu()->setCheckable(show);
}

#include "KoSelectAction.moc"
