/* This file is part of the KDE project
   Copyright (c) 2003 Rob Buis <buis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OODRAW_IMPORT_H__
#define OODRAW_IMPORT_H__

#include <KoFilter.h>
#include <KoStore.h>

#include <tqdom.h>
#include <tqdict.h>
#include <tqcolor.h>
#include <KoStyleStack.h>
#include <core/vdocument.h>
#include <core/vcomposite.h>
#include <core/vstroke.h>

class KZip;

class VGroup;

class OoDrawImport : public KoFilter
{
    Q_OBJECT
  
public:
    OoDrawImport( KoFilter *parent, const char *name, const TQStringList & );
    virtual ~OoDrawImport();

    virtual KoFilter::ConversionStatus convert( TQCString const & from, TQCString const & to );

private:
	void createDocumentInfo( TQDomDocument &docinfo );

	void createStyleMap( TQDomDocument &docstyles );
	void insertStyles( const TQDomElement& styles );
	void insertDraws( const TQDomElement& styles );
	void fillStyleStack( const TQDomElement& object );
	void addStyles( const TQDomElement* style );
	void storeObjectStyles( const TQDomElement& object );
	void appendPen( VObject &obj );
	void appendBrush( VObject &obj );
	void appendPoints(VPath &path, const TQDomElement& object);
	void convert();
	void parseGroup( VGroup *parent, const TQDomElement& object );
	void parseColor( VColor &color, const TQString &s );
	double ymirror( double y );
	KoRect parseViewBox( const TQDomElement& object );

	KoFilter::ConversionStatus openFile();
	KoFilter::ConversionStatus loadAndParse(const TQString& filename, TQDomDocument& doc);

	VDocument			m_document;
	TQDomDocument			m_content;
	TQDomDocument			m_meta;
	TQDomDocument			m_settings;
	TQDict<TQDomElement>		m_styles, m_draws;
	KoStyleStack			m_styleStack;
	KZip * m_zip;

};

#endif
