/***************************************************************************
                          knightstextview.cpp  -  description
                             -------------------
    begin                : Sun Dec 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knightstextview.moc"
#include "definitions.h"
#include "resource.h"
#include <kdebug.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <kurl.h>
#include <krun.h>

// Used for printing functionality
#include <tqpaintdevicemetrics.h>
#include <tqpainter.h>
#include <tqfontmetrics.h>
#include <kprinter.h>
#include <tqsimplerichtext.h>

KnightsTextView::KnightsTextView(TQWidget *parent, resource *Rsrc ) : TQTextBrowser(parent)
{
	myResource = Rsrc;
	setReadOnly( TRUE );
	setTextFormat( TQt::RichText );
	menuView = new TDEPopupMenu( this );
	/*
		Configure functions in the View right click menu
	*/
	menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("edit-copy"), TDEIcon::Small ) ),
												i18n( "&Copy" ), this, TQT_SLOT( menuFunct(int) ), CTRL+Key_C, MENU_COPY );
	menuView->insertItem( i18n("Select &All"), this, TQT_SLOT( menuFunct(int) ), CTRL+Key_A, MENU_SELECT_ALL );
	menuView->insertSeparator();
	menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("document-print"), TDEIcon::Small ) ),
												i18n( "&Print" ), this, TQT_SLOT( menuFunct(int) ), CTRL+Key_P, MENU_PRINT );
//  menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("edit-find"), TDEIcon::Small ) ),
//                        i18n( "&Find" ), this, TQT_SLOT( menuFunct(int) ), CTRL+Key_F, MENU_FIND );
//	menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("next"), TDEIcon::Small ) ),
//												i18n( "Find &Next" ), this, TQT_SLOT( menuFunct(int) ), Key_F3, MENU_FIND_NEXT );
//  menuView->insertSeparator();
	menuView->insertSeparator();
	menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("zoom-in"), TDEIcon::Small ) ),
												i18n( "Zoom &In" ), this, TQT_SLOT( menuFunct(int) ), 0, MENU_ZOOM_IN );
	menuView->insertItem( TQIconSet( Rsrc->LoadIcon( TQString("zoom-out"), TDEIcon::Small ) ),
												i18n( "Zoom &Out" ), this, TQT_SLOT( menuFunct(int) ), 0, MENU_ZOOM_OUT );

  /* disconnect the linkClicked signal so we can replace it with our own */
	disconnect(this, TQT_SIGNAL(linkClicked(const TQString&)),this ,0);
	/* connect the linkClicked signal to displayLink slot */
	connect(this, TQT_SIGNAL(linkClicked(const TQString&)), this, TQT_SLOT(displayLink(const TQString&)));

	show();
}

KnightsTextView::~KnightsTextView()
{
	delete menuView;
}

///////////////////////////////////////
//
//	KnightsTextView::viewportMousePressEvent
//
///////////////////////////////////////
void KnightsTextView::viewportMousePressEvent( TQMouseEvent *e )
{
	if( e->button() == Qt::RightButton )
	{
		emit rightButtonClicked( e->globalPos() );
		display_menuView( e->globalPos() );
	}
	TQTextEdit::viewportMousePressEvent( e );
}
///////////////////////////////////////
//
//	KnightsTextView::display_menuView
//
///////////////////////////////////////
void KnightsTextView::display_menuView( const TQPoint &Pos )
{
	if( hasSelectedText() )
	{
		menuView->setItemEnabled( MENU_COPY, TRUE );
	}
	else
	{
		menuView->setItemEnabled( MENU_COPY, FALSE );
	}
	menuView->popup( Pos );
}
///////////////////////////////////////
//
//	KnightsTextView::menuFunct
//
///////////////////////////////////////
void KnightsTextView::menuFunct( int funct )
{
	switch( funct )
	{
		case MENU_COPY:
			copy();
			break;
		case MENU_SELECT_ALL:
			selectAll();
			break;
		case MENU_ZOOM_IN:
			zoomIn();
			break;
		case MENU_ZOOM_OUT:
			zoomOut();
			break;
		case MENU_PRINT:
			print();
			break;
		default:
			break;
	}
}
///////////////////////////////////////
//
//	KnightsTextView::pageMove
//
///////////////////////////////////////
void KnightsTextView::pageMove( TQt::Key key )
{
	int NewY;
	if( key == Key_PageUp )
	{
		NewY = contentsY() - visibleHeight();
		if( NewY < 0 )
			NewY = 0;
	}
	else
	{
		NewY = contentsY() + visibleHeight();
		if( NewY > ( contentsHeight() - visibleHeight() ) )
			NewY = contentsHeight() - visibleHeight();
	}
	setContentsPos( 0, NewY );
	updateContents( 0, NewY, visibleWidth(), visibleHeight() );
}

///////////////////////////////////////
//
//	KnightsTextView::displayLink(TQString url)
//
///////////////////////////////////////
void KnightsTextView::displayLink(const TQString& urlString)
{
	KURL url(urlString);
	new KRun(url);
}

///////////////////////////////////////
//
//	KnightsTextView::print
//
///////////////////////////////////////
void KnightsTextView::print( void )
{
	KPrinter printer( true, TQPrinter::ScreenResolution );
	viewport()->setCursor( waitCursor );

	/* Make sure we want to print */
	if( printer.setup() )
	{
		TQPainter paint( &printer );
		TQPaintDeviceMetrics pageMetrics( paint.device() );

		/* Setup sizes */
		int dpix = pageMetrics.logicalDpiX();
		int dpiy = pageMetrics.logicalDpiY();
		const int margin = 36; // pt
		TQRect body( margin * dpix / 72, margin * dpiy / 72,
								pageMetrics.width() - margin * dpix / 72 * 2,
								pageMetrics.height() - margin * dpiy / 72 * 2 );
		TQRect view( body );

		printer.setFullPage( true );
		printer.setCreator( "Knights" );
		TQSimpleRichText simpText( this->text(), this->font() );
		simpText.setWidth( view.width() );

		/* Count Pages */
		int currentPage = 1;
		int totalPages = simpText.height() / view.height();
		if( view.height() * totalPages < simpText.height() )
		{
			totalPages++;
		}

		/* Print */
		while( 1 )
		{
			/* Print the Contents */
			paint.setClipRect( body );
			simpText.draw( &paint, body.left(), body.top(), view, colorGroup() );
			paint.setClipping( false );
			view.moveBy( 0, body.height() );
			paint.translate( 0, -body.height() );

			/* Print the Page Number */
			paint.setFont( myResource->FONT_Standard );
			paint.setPen( myResource->COLOR_Black );
			TQString pageCount = i18n( "Page %1 of %2" ).arg( currentPage ).arg( totalPages );
			paint.drawText( view.width() - paint.fontMetrics().width( pageCount ),
											view.bottom() + paint.fontMetrics().ascent() + 5, pageCount );
			if( view.top() >= simpText.height() )
			{
				break;
			}
			printer.newPage();
			currentPage++;
		}
	}

	/* Restore Playground */
	viewport()->unsetCursor();
}

void TQTextBrowser::setSource(const TQString&)
{
	/* overwrote this to stop clicked links from clearing the
 		 console */
}
