/***************************************************************************
                          kmymoneypriceview.h  -  description
                             -------------------
    begin                : Wed Mar 24 2004
    copyright            : (C) 2004 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYMONEYPRICEVIEW_H
#define KMYMONEYPRICEVIEW_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqwidget.h>
// class TQListViewItem;

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdepopupmenu.h>
#include <tdelistview.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/kmymoneylistviewitem.h>
//#include <kmymoney/mymoneymoney.h>
#include <kmymoney/mymoneyprice.h>

/**
  * @author Thomas Baumgart
  */

class KMyMoneyPriceItem : public KMyMoneyListViewItem
{
public:
  KMyMoneyPriceItem(TDEListView *, const MyMoneyPrice& pr);
  ~KMyMoneyPriceItem() {}

  int compare(TQListViewItem *p, int col, bool ascending) const;

  const MyMoneyPrice& price(void) const { return m_pr; };

private:
  MyMoneyPrice  m_pr;
};


class KMyMoneyPriceView : public TDEListView
{
   TQ_OBJECT
  
public:
  KMyMoneyPriceView(TQWidget *parent=0, const char *name=0);
  ~KMyMoneyPriceView();

protected:
  /// the resize event
  virtual void resizeEvent(TQResizeEvent*);

protected slots:
  void slotListClicked(TQListViewItem* item, const TQPoint&, int);

private slots:
  void slotTimerDone(void);

signals:
  void newPrice(void);
  void deletePrice(void);
  void editPrice(void);
  void onlinePriceUpdate(void);

private:
  TDEPopupMenu*     m_contextMenu;
  bool            m_showAll;
};

#endif
