/***************************************************************************
                          knewaccountdlg.h
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNEWACCOUNTDLG_H
#define KNEWACCOUNTDLG_H

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Headers

#ifdef HAVE_KDCHART
#include <KDChartWidget.h>
#include <KDChartTable.h>
#include <KDChartParams.h>
#endif

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneyaccount.h>
#include <kmymoney/mymoneymoney.h>
#include <kmymoney/kmymoneyedit.h>

#include "../dialogs/knewaccountdlgdecl.h"
class KMyMoneyAccountTreeBaseItem;
namespace reports {
  class KReportChartView;
};

/**
  * This dialog lets you create/edit an account.
  */
class KNewAccountDlg : public KNewAccountDlgDecl
{
  TQ_OBJECT
  

private:
  MyMoneyAccount m_account;
  MyMoneyAccount m_parentAccount;
  bool m_bSelectedParentAccount;

  KMyMoneyAccountTreeBaseItem *m_parentItem;
  KMyMoneyAccountTreeBaseItem *m_accountItem;
  bool m_categoryEditor;
  bool m_isEditing;

  int m_idPropFutureValue;
  int m_idPropLastValue;
  int m_idPropMaxCredit;
  int m_idPropMinBalance;

  void initParentWidget(TQString parentId, const TQString& accountId);
  void showSubAccounts(TQStringList accounts, KMyMoneyAccountTreeBaseItem *parentItem, const TQString& parentId, const TQString& accountId);
  void loadVatAccounts(void);
  void storeKVP(const TQString& key, kMyMoneyEdit* widget);
  void storeKVP(const TQString& key, KLineEdit* widget);
  void storeKVP(const TQString& key, const TQString& text, const TQString& value);
  void loadKVP(const TQString& key, kMyMoneyEdit* widget);
  void loadKVP(const TQString& key, KLineEdit* widget);

public:
  /**
    * This is the constructor of the dialog. The parameters define the environment
    * in which the dialog will be used. Depending on the environment, certain rules
    * apply and will be handled by the dialog.
    *
    * @param account The original data to be used to create the account. In case
    *                of @p isEditing is false, the account id, the parent account id
    *                and the list of all child accounts will be cleared.
    * @param isEditing If @p false, rules for new account creation apply.
    *                  If @p true, rules for account editing apply
    * @param categoryEditor If @p false, rules for asset/liability accounts apply.
    *                       If @p true, rules for income/expense account apply.
    * @param parent Pointer to parent object (passed to TQDialog). Default is 0.
    * @param name Name of the object (passed to TQDialog). Default is 0.
    * @param title Caption of the object (passed to TQDialog). Default is empty string.
    */
  KNewAccountDlg(const MyMoneyAccount& account, bool isEditing, bool categoryEditor, TQWidget *parent=0, const char *name=0, const TQString& title=TQString());

  /**
    * This method returns the edited account object.
    */
  const MyMoneyAccount& account(void);

  /**
    * This method returns the parent account of the edited account object.
    */
  const MyMoneyAccount& parentAccount(void);

  void setOpeningBalance(const MyMoneyMoney& balance);

  const MyMoneyMoney openingBalance(void) const { return m_openingBalanceEdit->value(); };

  void setOpeningBalanceShown(bool shown);

  /**
   * This method adds an additional tab pointed to with @a w to the tab widget.
   * This tab is usually defined by a plugin (eg. online banking). If @a w is
   * zero, this is a NOP. @a name is used as the text to be placed on the tab.
   */
  void addTab(TQWidget* w, const TQString& name);

protected:
  void resizeEvent(TQResizeEvent* e);
  void displayOnlineBankingStatus(void);
  void adjustEditWidgets(kMyMoneyEdit* dst, kMyMoneyEdit* src, char mode, int corr);

protected slots:
  void okClicked();
  void slotSelectionChanged(TQListViewItem *item);
  void slotAccountTypeChanged(const TQString& type);
  void slotVatChanged(bool);
  void slotVatAssignmentChanged(bool);
  void slotNewClicked(void);
  void slotCheckFinished(void);
  void slotLoadInstitutions(const TQString&);
  void slotAdjustMinBalanceAbsoluteEdit(const TQString&);
  void slotAdjustMinBalanceEarlyEdit(const TQString&);
  void slotAdjustMaxCreditAbsoluteEdit(const TQString&);
  void slotAdjustMaxCreditEarlyEdit(const TQString&);

private slots:
  void timerDone(void);

};

#endif

