/***************************************************************************
                          mymoneystoragexml.h  -  description
                             -------------------
    begin                : Thu Oct 24 2002
    copyright            : (C) 2002 by Kevin Tambascio
                           (C) 2004 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYSTORAGEXML_H
#define MYMONEYSTORAGEXML_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqdom.h>
#include <tqdatastream.h>
class TQIODevice;

// ----------------------------------------------------------------------------
// Project Includes

#include "imymoneyserialize.h"
#include "imymoneystorageformat.h"
class MyMoneyXmlContentHandler;

/**
  *@author Kevin Tambascio (ktambascio@users.sourceforge.net)
  */

#define VERSION_0_60_XML  0x10000010    // Version 0.5 file version info
#define VERSION_0_61_XML  0x10000011    // use 8 bytes for MyMoneyMoney objects

class MyMoneyStorageXML : public IMyMoneyStorageFormat
{
  friend class MyMoneyXmlContentHandler;
public:
  MyMoneyStorageXML();
  virtual ~MyMoneyStorageXML();

  enum fileVersionDirectionType {
    Reading = 0,          /**< version of file to be read */
    Writing = 1           /**< version to be used when writing a file */
  };

protected:
   void          setProgressCallback(void(*callback)(int, int, const TQString&));
   void          signalProgress(int current, int total, const TQString& = "");

  /**
    * This method returns the version of the underlying file. It
    * is used by the MyMoney objects contained in a MyMoneyStorageBin object (e.g.
    * MyMoneyAccount, MyMoneyInstitution, MyMoneyTransaction, etc.) to
    * determine the layout used when reading/writing a persistant file.
    * A parameter is used to determine the direction.
    *
    * @param dir information about the direction (reading/writing). The
    *            default is reading.
    *
    * @return version TQString of file's version
    *
    * @see m_fileVersionRead, m_fileVersionWrite
    */
  static unsigned int fileVersion(fileVersionDirectionType dir = Reading);

  TQValueList<TQDomElement> readElements(TQString groupTag, TQString itemTag = TQString());

  bool readFileInformation(const TQDomElement& fileInfo);
  virtual void writeFileInformation(TQDomElement& fileInfo);

  virtual void writeUserInformation(TQDomElement& userInfo);

  virtual void writeInstitution(TQDomElement& institutions, const MyMoneyInstitution& i);
  virtual void writeInstitutions(TQDomElement& institutions);

  virtual void writePrices(TQDomElement& prices);
  virtual void writePricePair(TQDomElement& price, const MyMoneyPriceEntries& p);
  virtual void writePrice(TQDomElement& prices, const MyMoneyPrice& p);

  virtual void writePayees(TQDomElement& payees);
  virtual void writePayee(TQDomElement& payees, const MyMoneyPayee& p);

  virtual void writeAccounts(TQDomElement& accounts);
  virtual void writeAccount(TQDomElement& accounts, const MyMoneyAccount& p);

  virtual void writeTransactions(TQDomElement& transactions);
  virtual void writeTransaction(TQDomElement& transactions, const MyMoneyTransaction& tx);

  virtual void writeSchedules(TQDomElement& scheduled);
  virtual void writeSchedule(TQDomElement& scheduledTx, const MyMoneySchedule& tx);

  virtual void writeReports(TQDomElement& e);
  virtual void writeBudgets(TQDomElement& e);
  virtual void writeBudget(TQDomElement& budget, const MyMoneyBudget& b);

  virtual void writeSecurities(TQDomElement& securities);
  virtual void writeSecurity(TQDomElement& securityElement, const MyMoneySecurity& security);

  virtual void writeCurrencies(TQDomElement& currencies);

  virtual TQDomElement writeKeyValuePairs(const TQMap<TQString, TQString> pairs);

  virtual void readFile(TQIODevice* s, IMyMoneySerialize* storage);
  virtual void writeFile(TQIODevice* s, IMyMoneySerialize* storage);

  bool readUserInformation(const TQDomElement& userElement);

  void readPricePair(const TQDomElement& pricePair);
  const MyMoneyPrice readPrice(const TQString& from, const TQString& to, const TQDomElement& price);

  TQDomElement findChildElement(const TQString& name, const TQDomElement& root);

private:
  void (*m_progressCallback)(int, int, const TQString&);

protected:
  IMyMoneySerialize *m_storage;
  TQDomDocument *m_doc;

private:
  /// \internal d-pointer class.
  class Private;
  /// \internal d-pointer instance.
  Private* const d;

  /**
    * This member is used to store the file version information
    * obtained while reading a file.
    */
  static unsigned int fileVersionRead;

  /**
    * This member is used to store the file version information
    * to be used when writing a file.
    */
  static unsigned int fileVersionWrite;
  /**
    * This member keeps the id of the base currency. We need this
    * temporarily to convert the price history from the old to the
    * new format. This should go at some time beyond 0.8 (ipwizard)
    */
  TQString m_baseCurrencyId;

};

#endif
