/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditcustom.h"



// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdeparts/genericfactory.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditcustomopt.h"

namespace KMF {
KMFRuleOptionEditCustom::KMFRuleOptionEditCustom(TQObject *parent, const char *name,const TQStringList& )
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditCustom::KMFRuleOptionEditCustom(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditCustomOpt( 0 , "Edit" );
	m_edit->hide();
	
	connect( m_edit,TQ_SIGNAL(sigHideMe() ), 
		this,TQ_SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditCustom::~KMFRuleOptionEditCustom() {}

void KMFRuleOptionEditCustom::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const TQString& KMFRuleOptionEditCustom::optionEditName() const {
	return *( new TQString( i18n("Custom Option") ) );
}
const TQString& KMFRuleOptionEditCustom::description() const {
	return *( new TQString( i18n("This plugin manages the Custom options.") ) );
}

void KMFRuleOptionEditCustom::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditCustom::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditCustom::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditCustom::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// // TDEInstance* KMFRuleOptionEditCustomFactory::s_instance = 0L;
// // TDEAboutData* KMFRuleOptionEditCustomFactory::s_about = 0L;

KMFRuleOptionEditCustomFactory::KMFRuleOptionEditCustomFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// // 	s_instance = new TDEInstance( "KMFRuleOptionEditCustomFactory" );
}

TQObject* KMFRuleOptionEditCustomFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditCustom( parent, name );
	emit objectCreated( obj );
	return obj;
}


// // TDEInstance* KMFRuleOptionEditCustomFactory::instance() {
// // 	if ( !s_instance ) {
// // 		s_instance = new TDEInstance( "KMFRuleOptionEditCustomFactory" );
// // 	}
// // 	return s_instance;
// // }

extern "C" {
	void* init_libkmfruleoptionedit_custom() {
		return new KMFRuleOptionEditCustomFactory;
	}
}


}

#include "kmfruleoptioneditcustom.moc"
