/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCHECKINPUT_H
#define KMFCHECKINPUT_H


/**
  *@author Christian Hubinger
  */

#include <tqdict.h>

#include <kdemacros.h>
class TQString;

namespace KMF {
class KMFError;

class KDE_EXPORT KMFCheckInput {
public:
	KMFCheckInput();
	~KMFCheckInput();

	/** Check the given input string is it matches the criterias
		for the given input type */
	void checkInput( const TQString& inp, const TQString& inp_type, KMFError* );

private:    // functions
	void generateMsgDict();
	
	/** Check if inp is a IP address */
	bool checkIP( TQString input );
	
	/** Check if inp is a FTQHN */
	bool checkFTQHN( TQString inp );
	
	/** Check if inp can be a chain name */
	bool checkChainName( TQString inp );
	
	/** Check if inp can be a rule name */
	bool checkRuleName( TQString inp );
	
	/** Check if inp is a MAC address */
	bool checkMAC( TQString inp );
	
	/** Check if inp is a net mask */
	bool checkNetMask ( TQString inp );
	
	/** Check if inp is a network */
	bool checkNetWork ( TQString inp );
	
	/** Check if inp is a port */
	bool checkPORT( TQString inp );
	
	/** Check if inp is a portrange */
	bool checkPORTRANGE( TQString inp );
	
	/** Check if inp is a multiport string */
	bool checkMULTIPORT( TQString inp );
private:     // data
	TQDict<TQString> m_msg_dict;
};
}
#endif
