/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITCUSTOM_H
#define KMFRULEOPTIONEDITCUSTOM_H

#include "../../core/kmfruleoptioneditinterface.h"

// QT includes
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstring.h>

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>
class TDEInstance;

namespace KMF {
class IPTRule;
class KMFRuleEditCustomOpt;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditCustom : public KMFRuleOptionEditInterface {
	TQ_OBJECT
  
public:
	KMFRuleOptionEditCustom(TQObject *parent = 0, const char *name = 0, const TQStringList& = TQString());

	~KMFRuleOptionEditCustom();
	void loadRule( IPTRule* rule );	
	TQWidget* editWidget();
	const TQString& optionEditName() const;
	const TQString& description() const;
	static TDEAboutData *createAboutData();

private slots:
	void slotShowOverview();
	
private:
	KMFRuleEditCustomOpt *m_edit;
	IPTRule *m_rule;
};



class KMFRuleOptionEditCustomFactory : public KLibFactory {
	TQ_OBJECT
  
public:
	KMFRuleOptionEditCustomFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditCustomFactory() {
/* 		delete s_instance; */
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = "TQObject",
	                               const TQStringList &args = TQStringList() );
	/*     static TDEInstance* instance(); */

/*private:
	static TDEInstance* s_instance;*/
};
}








#endif
