//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// License: GPL
//


#include "kmfdocumentinfo.h"

// QT includes
#include <tqstring.h>
#include <tqtextedit.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>


// KDE includes
#include <tdeapplication.h>
#include <kdebug.h>

// project includes
#include "../core/kmfdoc.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfundoengine.h"
namespace KMF {
KMFDocumentInfo::KMFDocumentInfo(TQWidget* parent, const char* name, bool modal, WFlags fl)
		: KMyFirewallDocumentInfo(parent,name, modal,fl) {
	connect( b_help, TQT_SIGNAL( clicked() ),
		this, TQT_SLOT( slotHelp() ) );
			connect( b_saveAsTemplate, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotSaveAsTemplate() ) );
	
}

KMFDocumentInfo::~KMFDocumentInfo() {}

void KMFDocumentInfo::slotSaveAsTemplate() {
	kdDebug() << "slotSaveAsTemplate()" << endl;
	emit sigSaveAsTemplate();
}

/*$SPECIALIZATION$*/
void KMFDocumentInfo::accept() {
	if ( ! txt_name->text().isNull() ) {
		m_doc->setName( txt_name->text() );
//		m_doc->changed();
		// m_doc->network()->changed();
	}
	
	if ( ! txt_description->text().isNull() ) {
		m_doc->setDescription( txt_description->text() );
//		m_doc->changed();
		// m_doc->network()->changed();
	}
	
	TQDialog::accept();
}

void KMFDocumentInfo::loadDoc( KMFDoc* doc ) {
	m_doc = doc;
	txt_name->setText( doc->name() );
	txt_description->setText( doc->description() );
}

void KMFDocumentInfo::slotHelp() {
	kdDebug() << "void KMFDocumentInfo::slotHelp()" << endl;
	kapp->invokeHelp();
}


}

#include "kmfdocumentinfo.moc"

