/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditcustomopt.h"

// KDE includes
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdelocale.h> 

// QT includes
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqcheckbox.h>

// Project includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"

namespace KMF {
KMFRuleEditCustomOpt::KMFRuleEditCustomOpt( TQWidget *parent, const char *name ) : KMyFirewallRuleEditorCustomRule( parent, name ) {
	c_options->setChecked( false );
	c_target_options->setChecked( false );
	t_target->clear();
	t_target_options->clear();
	t_options->clear();
}

KMFRuleEditCustomOpt::~KMFRuleEditCustomOpt() {
}

void KMFRuleEditCustomOpt::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditIP::loadRule( IPTRule * rule )" << endl;
	if ( rule == 0 )
		return ;

	m_rule = rule;
	t_target->clear();
	t_target->setText( m_rule->target() );
	t_target_options->clear();
	t_options->clear();
	IPTRuleOption *opt;
	TQStringList vals;
	TQString val = "";

	opt  = m_rule->getOptionForName("custom_opt");
	vals = opt->getValues();
	val = *vals.at(0);
	if ( val != XML::Undefined_Value && !val.isEmpty() && val != XML::BoolOff_Value ) {
		c_options->setChecked( true );
		t_options->setText( val );
	}
	vals.clear();
	val = "";

	opt  = m_rule->getOptionForName("target_custom_opt");
	vals = opt->getValues();
	val = *vals.at(0);
	if ( val != XML::Undefined_Value && !val.isEmpty() && val != XML::BoolOff_Value ) {
		c_target_options->setChecked( true );
		t_target_options->setText( val );
	}
	return ;
}

void KMFRuleEditCustomOpt::accept() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Custom Rule: %1 Option").arg( m_rule->name() ) 
	);
	TQString target = "";
	target = t_target->text();
	TQString option = "";
	if ( c_options->isChecked() )
		option = t_options->text();
	TQString target_option = "";
	if ( c_target_options->isChecked() )
		target_option = t_target_options->text();
	TQString* op = new TQString( "custom_opt" );
	TQString *tg_opt = new TQString( "target_custom_opt" );
	TQPtrList<TQString>* values = new TQPtrList<TQString>;

	kdDebug() << "target: " << target << endl;
	kdDebug() << "option: " << option << endl;
	kdDebug() << "target_option: " << target_option << endl;
	if ( !c_options->isChecked() && ! c_target_options->isChecked() ) {
		m_rule->setCustomRule( false );
		m_rule->addRuleOption( *op, *values );
		m_rule->addRuleOption( *tg_opt, *values );
		KMFUndoEngine::instance()->abortTransaction();
		emit sigHideMe();
		return ;
	}

	m_rule->setCustomRule( true );
	if ( !target.isEmpty() )
		m_rule->setTarget( *( new TQString( target ) ) );

	if ( !option.isEmpty() ) {
		values->append( new TQString( option ) );
	} else {
		values->append( new TQString( XML::BoolOff_Value ) );
	}
	m_rule->addRuleOption( *op, *values );
	values->clear();

	if ( !target_option.isEmpty() ) {
		values->append( new TQString( target_option ) );
	} else {
		values->append( new TQString( XML::BoolOff_Value ) );
	}
	
	m_rule->addTargetOption( *tg_opt, *values );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditCustomOpt::slotHelp() {
	kdDebug() << "void KMFRuleEditIP::slotHelp()" << endl;
	kapp->invokeHelp( "custom_rules" );
}

void KMFRuleEditCustomOpt::reject() {
	kdDebug() << "void KMFRuleEditCustomOpt::reject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleeditcustomopt.moc"
