//
// C++ Implementation: kmftqtdesignerplugin
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmftqtdesignerplugin.h"

// TQt includes


// Prokject includes
#include "kmfipv4addresswidget.h"
namespace KMF {
TQ_EXPORT_PLUGIN( KMFTQTDesignerPlugin )

KMFTQTDesignerPlugin::KMFTQTDesignerPlugin()
		: TQWidgetPlugin() {}


KMFTQTDesignerPlugin::~KMFTQTDesignerPlugin() {}

TQStringList KMFTQTDesignerPlugin::keys() const {
	TQStringList list;
	list << "KMFIPv4AddressWidget";
	return list;
}

TQWidget* KMFTQTDesignerPlugin::create ( const TQString &key, TQWidget* parent, const char* name ) {
	if ( key == "KMFIPv4AddressWidget" )
		return new KMFIPv4AddressWidget ( parent, name );
	return 0;
}


TQString KMFTQTDesignerPlugin::group ( const TQString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "Input";
	return TQString();
}

TQIconSet KMFTQTDesignerPlugin::iconSet ( const TQString& ) const {
	return TQIconSet ( TQPixmap ( TQString("filechooser_pixmap") ) );
}

TQString KMFTQTDesignerPlugin::includeFile ( const TQString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "kmfipv4addresswidget.h";
	return TQString();
}

TQString KMFTQTDesignerPlugin::toolTip ( const TQString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "File Chooser Widget";
	return TQString();
}

TQString KMFTQTDesignerPlugin::whatsThis ( const TQString& feature ) const {
	if ( feature == "KMFIPv4AddressWidget" )
		return "A widget to change an IPv4 Address";
	return TQString();
}

bool KMFTQTDesignerPlugin::isContainer ( const TQString& ) const {
	return FALSE;
}

}
