/***************************************************************************
 *   Copyright (C) 2005 by Lorenzo Bettini                                 *
 *   http://www.lorenzobettini.it                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BRIGHTNESSCHOOSERIMPL_H
#define BRIGHTNESSCHOOSERIMPL_H

#include <brightnesschooser.h>

class TQProcess;

/**
Implementation slots for BrightnessChooser

@author Lorenzo Bettini, http://www.lorenzobettini.it,,
*/
class BrightnessChooserImpl : public BrightnessChooser
{
Q_OBJECT
public:
    BrightnessChooserImpl(TQWidget *parent = 0, const char *name = 0);

    ~BrightnessChooserImpl();

    /**
     * Updates the slider properties according to the global
     * properties.
     */
    void updateSlider();

    /**
     * Returns the current value of brightness.
     * @return 
     */
    const TQString getValue();

    /**
     * Sets the current value of brightness
     * @param val 
     */
    void setValue(const TQString &val);

    /// retrieve the current brightness
    void getBrightness();

    protected slots:
        void updateBrightness();
        void updateValue(int);
        void readFromStderr();
        void readFromStdout();
        void readValueFromStdout();
        void procExited();

    private:
        /// process instance used to adjust brightness
        TQProcess *proc;

    signals:
        void valueUpdated();

    protected:
        /// to intercept the Enter key press and direct it to OK button
        void keyPressEvent( TQKeyEvent * );

};

#endif
