/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SCHEDULE_H_
#define _SCHEDULE_H_

#include <tqvariant.h>
#include <tqdialog.h>
#include <tqspinbox.h> 

#include <tqdatetime.h> 
#include <tqlineedit.h> 
#include <tqstring.h>
#include <tqtimer.h>
#include <tqvalidator.h>
#include <tqwidget.h>
#include <tqcheckbox.h>

#include "cthost.h"
#include "cttask.h"
#include "ctcron.h"

#include <kdatepicker.h>
#include <knuminput.h>


class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
//class TQListView;
class KTView;
class TQListViewItem;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class CollectionSetup;
class TQToolButton;
class TQHBoxLayout;
class KProcIO;

class HMSTimeWidget : public KIntSpinBox
{
  TQ_OBJECT
 public:
  HMSTimeWidget(TQWidget *parent=0, const char *name=0);
 protected:
  TQString mapValueToText(int);
};

class KStrictIntValidator : public TQIntValidator 
{
public:
  KStrictIntValidator(int bottom, int top, TQWidget * parent,
		      const char * name = 0 )
    : TQIntValidator(bottom, top, parent, name) {};
  
  TQValidator::State validate( TQString & input, int & d ) const; 
};

/**
 * This class serves as the main window for Schedule.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Schedule  : public TQDialog
{
    TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    Schedule( TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );

    /**
     * Default Destructor
     */
    virtual ~Schedule();

    /**
     * Use this method to load whatever file/URL you have
     */
    
    void  setDirName(TQString);
    bool isMultiScan();
    const CTHost& getCTHost() const;

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:

	void slotQueryDatePicker(int index);
	void slotAddDateToCombo(TQDate newdate);
	void slotScheduleScan();
	void slotDelete();
	void slotOK();
	void slotCancel();

  void slotICEoutput(KProcIO *);
  void slotICEexited();
private:
    void setupAccel();
    void setupActions();
    TQString createScanScript();
    TQString createStartupScript();

    TQString iceauth;
    void getICEauth();
private:

signals:

public slots:
private slots:
private:
    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo, *check_combo;
    TQCheckBox *recursive_box;
//    TQListView *resultview;
    TQPushButton *search_button, *cancel_button;
    TQLabel *status_label, *status2_label,*matches_label,*matches2_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig* config;
    bool errorsEncountered;
    TQPushButton* adv_options;
    TQString urlsToScan;
    TQString prevdir;
    TQStringList listOfUrlsToScan;
    bool multi_recursive;
    CollectionSetup* setup;
    TQToolButton *m_tabsClose;
    TQToolButton* play;
    TQToolButton* stop;
    TQHBoxLayout* controls;
    TQDate _date;
    HMSTimeWidget* hour;
    HMSTimeWidget* minute;
    TQStringList filepattern;
    KTView *schedulebox;
    CTHost* cthost;
    CTTask* cttask;
    CTCron* ctcron;
    KProcIO *iceproc;
};


#endif // _SCHEDULE_H_
