/* ============================================================
 * File  : plugin_galleryexport.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-11-06
 * Description :
 *
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef PLUGIN_GALLERYEXPORT_H
#define PLUGIN_GALLERYEXPORT_H

// libKIPI includes.

#include <libkipi/plugin.h>

class TDEAction;

namespace KIPIGalleryExportPlugin
{
class Galleries;
}

class Plugin_GalleryExport : public KIPI::Plugin
{
    TQ_OBJECT
  

public:

    Plugin_GalleryExport(TQObject *parent,
                         const char* name,
                         const TQStringList &args);
    ~Plugin_GalleryExport();
    
    virtual KIPI::Category category( TDEAction* action ) const;
    virtual void setup( TQWidget* );

public slots:

    void slotSync();
    void slotConfigure();
    void slotCollectionSettings();
    void slotImageSettings();

private:

    TDEAction *m_action_sync;
    TDEAction *m_action_configure;
    TDEAction *m_action_collection_settings;
    TDEAction *m_action_image_setting;
    
    KIPIGalleryExportPlugin::Galleries* mpGalleries;
};

#endif
