/* ============================================================
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef CAMERASELECTION_H
#define CAMERASELECTION_H

// TQt includes.

#include <tqstring.h>
#include <tqstringlist.h>

// KDE includes.

#include <kdialogbase.h>

// Local includes

#include "kpaboutdata.h"

class TQComboBox;
class TQListView;
class TQListViewItem;
class TQRadioButton;
class TQVButtonGroup;
class TQLabel;
class TQLineEdit;
class TQPushButton;

namespace KIPIKameraKlientPlugin
{

class CameraSelection : public KDialogBase 
{
    Q_OBJECT
  

public:
    
    CameraSelection( TQWidget* parent = 0 );
    ~CameraSelection();
    
    void setCamera(const TQString& model, const TQString& port);
    TQString currentModel();
    TQString currentPortPath();

private:
    
    void getCameraList();
    void getSerialPortList();
    
    TQListView*     listView_;
    
    TQVButtonGroup* portButtonGroup_;
    
    TQRadioButton*  usbButton_;
    TQRadioButton*  serialButton_;
    
    TQLabel*        portPathLabel_;
    
    TQComboBox*     portPathComboBox_;
    
    TQStringList    serialPortList_;
    
    TQPushButton*   helpButton_;
    
    KIPIPlugins::KPAboutData*   m_about;

private slots:
    
    void slotSelectionChanged(TQListViewItem *item);
    void slotPortChanged();
    void slotOkClicked();
    void slotHelp();   
    
signals:
    
    void signalOkClicked(const TQString& model, const TQString& port);
};

}  // NameSpace KIPIKameraKlientPlugin

#endif 
