/***************************************************************************
                         latexcmddialog.h
                         --------------
    date                 : Jul 25 2005
    version              : 0.20
    copyright            : (C) 2005 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef LATEXCMDDIALOG_H
#define LATEXCMDDIALOG_H

#include <kpushbutton.h>
#include <kdialogbase.h>
#include <klineedit.h>
#include <tdelistview.h>
#include <tdeconfig.h>

#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqlistview.h>
#include <tqstringlist.h>
#include <tqtabwidget.h>
#include <tqmap.h>

#include "latexcmd.h"

namespace KileDialog
{

class NewLatexCommand : public KDialogBase  
{
	Q_OBJECT
  

public:
	NewLatexCommand(TQWidget *parent, const TQString &caption,
                   const TQString &groupname, TDEListViewItem *lvitem,
	                KileDocument::CmdAttribute cmdtype, TQMap<TQString,bool> *dict);
	~NewLatexCommand() {}
	void getParameter(TQString &name, KileDocument::LatexCmdAttributes &attr);

private:
	KLineEdit *m_edName;
	TQCheckBox *m_chStarred, *m_chEndofline, *m_chMath; 
	TQComboBox *m_coTab, *m_coOption, *m_coParameter;
	
	bool m_addmode, m_envmode;
	bool m_useMathOrTab, m_useOption, m_useParameter;
	KileDocument::CmdAttribute m_cmdType;
	TQMap<TQString,bool> *m_dict;
	
private slots:
	void slotOk();
};


class LatexCommandsDialog : public KDialogBase  
{
	Q_OBJECT
  

public:
	LatexCommandsDialog(TDEConfig *config, KileDocument::LatexCommands *commands, TQWidget *parent=0, const char *name=0);
	~LatexCommandsDialog() {}
	
	//enum EnvParameter { envName,envStarred,envEOL,envMath,envTab,envOption };

private:
	enum LVmode { lvEnvMode=1, lvCmdMode=2 };
	
	TDEConfig *m_config;
	KileDocument::LatexCommands *m_commands;
	TQMap<TQString,bool> m_dictCommands;
	bool m_commandChanged;
		
	TDEListView *m_lvEnvironments, *m_lvCommands;
	TDEListViewItem *m_lviList,*m_lviTabular,*m_lviMath,*m_lviAmsmath,*m_lviVerbatim;
	TDEListViewItem *m_lviLabels,*m_lviReferences,*m_lviCitations;
	TDEListViewItem *m_lviInputs;
	TQTabWidget *m_tab;
	KPushButton *m_btnAdd, *m_btnDelete, *m_btnEdit;
	TQCheckBox *m_cbUserDefined;
	
	void resetListviews();
	LVmode getListviewMode();
	KileDocument::CmdAttribute getCommandMode(TDEListViewItem *item);
	bool isParentItem(TDEListViewItem *item);

	void setEntry(TDEListViewItem *parent,const TQString &name,KileDocument::LatexCmdAttributes &attr);
	void getEntry(TDEListViewItem *item,KileDocument::LatexCmdAttributes &attr);
	 
	bool isUserDefined(const TQString &name);
	bool hasUserDefined(TDEListView *listview);
	
	void resetEnvironments();
	void resetCommands();
	void getListviewStates(bool states[]);
	void setListviewStates(bool states[]);
	
	void readConfig();
	void writeConfig(TDEListView *listview, const TQString &groupname, bool env);
	
private slots:
	void slotPageChanged(TQWidget *);
	void slotEnableButtons();
	void slotAddClicked();
	void slotDeleteClicked();
	void slotEditClicked();
	void slotUserDefinedClicked();
	void slotHelp();
	void slotOk();
};

}

#endif
