/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdeconfig.h>
#include <tdeapplication.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <kiconloader.h>

#include <tqlayout.h>
#include <tqobjectlist.h>
#include <tqguardedptr.h>
#include <tqlineedit.h>
#include <tqvaluelist.h>
#include <tqtimer.h>
#include <tqcursor.h>
#include <tqlabel.h>
#include <tqstyle.h>
#include <tqimage.h>

#ifdef TQ_WS_X11
#include <netwm.h>
#endif

#include "processingdialog.h"

ProcessingDialogHeader::ProcessingDialogHeader(TQWidget* parent)
  : TQWidget( parent, "", TQt::WDestructiveClose )
{
	TQVBoxLayout* vbox = new TQVBoxLayout( this );

	TQFrame* frame = new TQFrame( this );
	frame->setFrameStyle( TQFrame::NoFrame );
	frame->setLineWidth( 0 );
	// we need to set the minimum size for the window
	frame->setMinimumWidth(300);
	vbox->addWidget( frame );
	TQGridLayout* gbox = new TQGridLayout( frame, 1, 1, 0, KDialog::spacingHint() );
	TQHBoxLayout* centerbox = new TQHBoxLayout( KDialog::spacingHint() );
	TQHBoxLayout* seperatorbox = new TQHBoxLayout( 0 );
	centerbox->setMargin(0);
	seperatorbox->setMargin(0);

	TQWidget* swidget = new TQWidget( frame );
	swidget->resize(2, frame->sizeHint().width());
	swidget->setBackgroundColor(TQt::black);
	seperatorbox->addWidget( swidget, AlignCenter );

	TQLabel* label = new TQLabel( i18n("LDAP/Kerberos Realm Configuration"), frame );
	TQFont fnt = label->font();
	fnt.setBold( true );
	label->setFont( fnt );
	centerbox->addWidget( label, AlignCenter );

	gbox->addLayout(centerbox, 0, 0);
	gbox->addLayout(seperatorbox, 1, 0);

	setFixedSize( sizeHint() );
}

ProcessingDialogHeader::~ProcessingDialogHeader()
{
}

ProcessingDialog::ProcessingDialog(TQWidget* parent)
  : TQWidget( parent, "systemmodaldialogclass", TQt::WType_Dialog | TQt::WDestructiveClose ), m_keepOnTopTimer(NULL), m_allowClose(false)

{
	// Signal that we do not want any window controls to be shown at all
	Atom kde_wm_system_modal_notification;
	kde_wm_system_modal_notification = XInternAtom(tqt_xdisplay(), "_TDE_WM_MODAL_SYS_NOTIFICATION", False);
	XChangeProperty(tqt_xdisplay(), winId(), kde_wm_system_modal_notification, XA_INTEGER, 32, PropModeReplace, (unsigned char *) "TRUE", 1L);

	TQVBoxLayout* vbox = new TQVBoxLayout( this );

	TQFrame* frame = new TQFrame( this );
	frame->setFrameStyle( TQFrame::NoFrame );
	frame->setLineWidth( style().pixelMetric( TQStyle::PM_DefaultFrameWidth, frame ) );
	// we need to set the minimum size for the window
	frame->setMinimumWidth(400);
	vbox->addWidget( frame );
	TQGridLayout* gbox = new TQGridLayout( frame, 1, 1, KDialog::marginHint(), KDialog::spacingHint() );
	TQHBoxLayout* centerbox = new TQHBoxLayout( frame, 0, KDialog::spacingHint() );

	m_statusLabel = new TQLabel( i18n("Pondering what to do next").append("..."), frame );
	TQFont fnt = m_statusLabel->font();
	fnt.setBold( false );
	fnt.setPointSize( fnt.pointSize() * 1 );
	m_statusLabel->setFont( fnt );
	gbox->addMultiCellWidget( m_statusLabel, 2, 2, 0, 0, AlignLeft | AlignVCenter );

	ProcessingDialogHeader *theader = new ProcessingDialogHeader(this);
	centerbox->addWidget( theader, AlignCenter );

	gbox->addLayout(centerbox, 0, 0);

	setFixedSize( sizeHint() );
	setCaption( i18n("Please wait...") );

	// Center the dialog
	TQSize sh = sizeHint();
	TQRect rect = parent->geometry();
	move(rect.x() + (rect.width() - sh.width())/2, rect.y() + (rect.height() - sh.height())/2);

	show();
	keepMeOnTop();
}

ProcessingDialog::~ProcessingDialog()
{
	m_keepOnTopTimer->stop();
	delete m_keepOnTopTimer;
}

void ProcessingDialog::keepMeOnTop()
{
	if (!m_keepOnTopTimer) {
		m_keepOnTopTimer = new TQTimer();
		connect(m_keepOnTopTimer, TQ_SIGNAL(timeout()), this, TQ_SLOT(keepMeOnTop()));
		m_keepOnTopTimer->start(100, FALSE);
	}
	setActiveWindow();
	raise();
	setFocus();
}

void ProcessingDialog::setStatusMessage(TQString message)
{
    if (message == "") {
        m_statusLabel->setText(i18n("Pondering what to do next").append("..."));
    }
    else {
        m_statusLabel->setText(message);
    }
}

void ProcessingDialog::closeDialog()
{
	m_allowClose = true;
	close();
}

void ProcessingDialog::closeEvent(TQCloseEvent *e)
{
	//---------------------------------------------
	// Don't call the base function because
	// we want to ignore the close event
	//---------------------------------------------

	if (m_allowClose)
		TQWidget::closeEvent(e);
}

#include "processingdialog.moc"
