/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef CTREEVIEWITEM_H
#define CTREEVIEWITEM_H

#include <tqlistview.h>
#include <tqvaluevector.h>

#include "libchmfile.h"

/**
@author Georgy Yunaev
*/
//! This is a list item used both in Index and Table Of Content trees
class KCHMIndTocItem : public TQListViewItem
{
	public:
		KCHMIndTocItem( TQListViewItem* parent, TQListViewItem* after, TQString name, TQString aurl, int image); 
		KCHMIndTocItem( TQListView* parent, TQListViewItem* after, TQString name, TQString url, int image);
		
		TQString		getUrl() const;
		virtual void setOpen ( bool open );
		
	private:
		virtual void paintBranches ( TQPainter * p, const TQColorGroup & cg, int w, int y, int h );
		virtual void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );
		virtual const TQPixmap * pixmap( int i ) const;
		
		TQString		url;
		int 		image_number;
};


class KCMSearchTreeViewItem : public TQListViewItem
{
	public:
		KCMSearchTreeViewItem (TQListView* parent, TQString name, TQString loc, TQString url)
			: TQListViewItem (parent, name, loc)
		{
			this->url = url;
		}
	
		TQString		getUrl() const	{ return url; }
		
	private:
		TQString		url;
};


class KCHMSingleTreeViewItem : public TQListViewItem
{
	public:
		KCHMSingleTreeViewItem (TQListView* parent, TQString name, TQString url)
			: TQListViewItem (parent, name)
		{
			this->url = url;
		}
	
		TQString		getUrl() const	{ return url; }
		
	private:
		TQString		url;
};


class KCHMBookmarkTreeViewItem : public TQListViewItem
{
	public:
		KCHMBookmarkTreeViewItem (TQListView* parent, TQString n, TQString u, int s)
			: TQListViewItem (parent, n), url(u), name(n), scroll_y(s) {	menuid = 0; }
	
		TQString		url;
		TQString		name;
		int			scroll_y;
		int			menuid;
};


void kchmFillListViewWithParsedData( TQListView * list, const TQValueVector< LCHMParsedEntry >& data, TQMap<TQString, KCHMIndTocItem*> * map );

#endif
