/*
 * kbiff.h
 * Copyright (C) 1999-2004 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the main KBiff
 * widget.
 *
 * $Id$
 */
#ifndef KBIFF_H 
#define KBIFF_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <tqptrlist.h>

#include <kbiffmonitor.h>
#include <setupdlg.h>

#include <kbiffurl.h>
#include <kapp.h>

#include <tqlabel.h>
#include <tqtimer.h>

#include <notify.h>
#include <status.h>

#include <dcopclient.h>
#include <dcopobject.h>

class Led;

class KBiff : public TQLabel, virtual public DCOPObjectProxy
{
    TQ_OBJECT
public:
    KBiff(DCOPClient *client_, TQWidget *parent_ = 0);
    virtual ~KBiff();

    bool isDocked() const;

    void processSetup(const KBiffSetup* setup, bool start);
    void readSessionConfig();

    void setMailboxList(const TQPtrList<KBiffMailbox>& mailbox_list, unsigned int poll = 60);

    virtual bool process(const TQCString& obj, const TQCString& function,
                         const TQByteArray& data, TQCString& replyType,
                         TQByteArray &replyData );

public slots:
    void slotPlaySound(const TQString&);
    void slotLaunchFetchClient(const TQString&);
    void slotLaunchMailClient();

protected:
    void mousePressEvent(TQMouseEvent *);
    void enterEvent(TQEvent *);
    void leaveEvent(TQEvent *);

protected:
    void popupMenu();
    void reset();
    bool isRunning();
    bool isGIF8x(const TQString & file);
    void executeCommand(const TQString& command);
    void registerMe(DCOPClient *client);

protected slots:
    void saveYourself();
    void invokeHelp();
    void displayPixmap();
    void haveNewMail(const int, const TQString &);
    void haveNoNewMail();
    void currentStatus(const int, const TQString &, const KBiffMailState);
    void dock();
    void setup();
    void checkMailNow();
    void readMailNow();
    void readPop3MailNow();
    void stop();
    void start();
    void popupStatus();
    void invalidLogin(const TQString& mailbox);

private:
    bool findMailbox(const TQString& url, TQString& proxy);
    int newMailCount(const TQString& url);

    TQString getURLWithNewMail();
    TQString getMailBoxWithNewMail();
    TQString replaceCommandArgs(TQString cmdStr);

protected:
    bool myMUTEX;
    TQPtrList<KBiffMonitor> monitorList;
    TQPtrList<KBiffNotify>  notifyList;
    KBiffStatusList     statusList;
    TQStringList         proxyList;

    // Capability
    TQTimer  *statusTimer;
    
    // General settings
    TQString profile;
    TQString mailClient;

    // New mail
    bool    systemBeep;
    bool    runCommand;
    TQString runCommandPath;
    bool    runResetCommand;
    TQString runResetCommandPath;
    bool    playSound;
    TQString playSoundPath;
    bool    notify;
    bool    dostatus;

    bool    docked;
    bool    sessions;
    bool    skipcheck;

    bool    isSecure;

    TQString noMailIcon;
    TQString newMailIcon;
    TQString oldMailIcon;
    TQString noConnIcon;
    TQString stoppedIcon;

    KBiffStatus *status;
    bool         statusChanged;

    Led *mled;
};

#endif // KBIFF_H 
