/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqheader.h>
#include <tqtimer.h>
#include <tqtooltip.h>

#include <tdelistview.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <tdelocale.h>

#include "file.h"
#include "entryfield.h"
#include "value.h"
#include "entry.h"
#include "settings.h"
#include "settingskeyword.h"

namespace KBibTeX
{

    SettingsKeyword::SettingsKeyword( TQWidget *parent, const char *name ) : TQWidget( parent, name ), m_keywords( NULL )
    {
        setupGUI();
    }

    SettingsKeyword::~SettingsKeyword()
    {
        // nothing
    }

    void SettingsKeyword::applyData()
    {
        Settings * settings = Settings::self();
        settings->keyword_GlobalList.clear();
        for ( TQListViewItemIterator it = TQListViewItemIterator( m_listKeywords ); it.current() != NULL; ++it )
            settings->keyword_GlobalList.append( it.current() ->text( 0 ) );
        settings->keyword_GlobalList.sort();
    }

    void SettingsKeyword::readData()
    {
        Settings * settings = Settings::self();
        m_listKeywords->clear();
        for ( TQStringList::Iterator it = settings->keyword_GlobalList.begin(); it != settings->keyword_GlobalList.end(); ++it )
        {
            TDEListViewItem *item = new TDEListViewItem( m_listKeywords, *it );
            item->setPixmap( 0, SmallIcon( "package" ) );
        }

//         Settings * settings = Settings::self();
        BibTeX::File *bibtexFile = settings->currentBibTeXFile;
//         m_keywordsFromFile.clear();
        if ( bibtexFile != NULL )
//         {
            m_keywordsFromFile = bibtexFile->getAllValuesAsStringList( BibTeX::EntryField::ftKeywords );

        m_buttonImportKeywords->setEnabled( m_keywordsFromFile.size() > 0 );
    }

    void SettingsKeyword::slotNewKeyword()
    {
        TDEListViewItem * item = new TDEListViewItem( m_listKeywords, i18n( "New Keyword" ) );
        item->setPixmap( 0, SmallIcon( "package" ) );
        m_listKeywords->setSelected( item, TRUE );
        m_listKeywords->ensureItemVisible( item );
        TQTimer::singleShot( 100, this, TQ_SLOT( slotEditKeyword() ) );
    }

    void SettingsKeyword::slotEditKeyword()
    {
        TDEListViewItem * item = static_cast<TDEListViewItem*>( m_listKeywords->selectedItem() );
        if ( item != NULL )
        {
            m_oldText = item->text( 0 );
            m_listKeywords->rename( item, 0 );
        }
    }

    void SettingsKeyword::slotDeleteKeyword()
    {
        TDEListViewItem * item = static_cast<TDEListViewItem*>( m_listKeywords->selectedItem() );
        if ( item != NULL )
        {
            delete item;
            emit configChanged();
        }
        updateGUI();
    }

    void SettingsKeyword::slotImportKeywords()
    {
        int numImported = m_keywordsFromFile.size();
        for ( TQListViewItemIterator it = TQListViewItemIterator( m_listKeywords ); it.current() != NULL; ++it )
        {
            TQString text = it.current() ->text( 0 );
            if ( !m_keywordsFromFile.contains( text ) )
                m_keywordsFromFile.append( text );
            else
                numImported--;
        }

        m_keywordsFromFile.sort();
        m_listKeywords->clear();
        for ( TQStringList::Iterator it = m_keywordsFromFile.begin(); it != m_keywordsFromFile.end(); ++it )
        {
            TDEListViewItem *item = new TDEListViewItem( m_listKeywords, *it );
            item->setPixmap( 0, SmallIcon( "package" ) );
        }

        KMessageBox::information( this, i18n( "1 keyword has been imported.", "%n keywords have been imported.", numImported ), i18n( "Keywords imported" ) );

        m_buttonImportKeywords->setEnabled( FALSE );
    }

    void SettingsKeyword::slotItemRenamed( TQListViewItem *item )
    {
        TQString newText = item->text( 0 ).stripWhiteSpace();
        if ( newText.isEmpty() )
            item->setText( 0, m_oldText );
        else
        {
            item->setText( 0, newText );
            emit configChanged();
        }
        updateGUI();
    }

    void SettingsKeyword::updateGUI()
    {
        bool selected = m_listKeywords->selectedItem() != NULL;
        m_buttonEditKeyword->setEnabled( selected );
        m_buttonDeleteKeyword->setEnabled( selected );
    }

    void SettingsKeyword::setupGUI()
    {
        TQGridLayout * gridLayout = new TQGridLayout( this, 5, 2, 0, KDialog::spacingHint(), "gridLayout" );

        m_listKeywords = new TDEListView( this );
        m_listKeywords->addColumn( i18n( "Keywords" ) );
        m_listKeywords->header()->setClickEnabled( FALSE );
        m_listKeywords->setFullWidth( true );
        gridLayout->addMultiCellWidget( m_listKeywords, 0, 4, 0, 0 );

        m_buttonNewKeyword = new TQPushButton( i18n( "keyword", "New" ), this );
        m_buttonNewKeyword->setIconSet( TQIconSet( SmallIcon( "add" ) ) );
        gridLayout->addWidget( m_buttonNewKeyword, 0, 1 );
        m_buttonEditKeyword = new TQPushButton( i18n( "keyword", "Edit" ), this );
        m_buttonEditKeyword->setIconSet( TQIconSet( SmallIcon( "edit" ) ) );
        gridLayout->addWidget( m_buttonEditKeyword, 1, 1 );
        m_buttonDeleteKeyword = new TQPushButton( i18n( "keyword", "Delete" ), this );
        m_buttonDeleteKeyword->setIconSet( TQIconSet( SmallIcon( "edit-delete" ) ) );
        gridLayout->addWidget( m_buttonDeleteKeyword, 2, 1 );

        m_buttonImportKeywords = new TQPushButton( i18n( "keyword", "Import" ), this );
        m_buttonImportKeywords->setIconSet( TQIconSet( SmallIcon( "openfile" ) ) );
        TQToolTip::add( m_buttonImportKeywords, "Import all keywords from the current BibTeX file" );
        gridLayout->addWidget( m_buttonImportKeywords, 4, 1 );
        connect( m_buttonImportKeywords, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotImportKeywords() ) );

        connect( m_buttonNewKeyword, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotNewKeyword() ) );
        connect( m_buttonEditKeyword, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotEditKeyword() ) );
        connect( m_buttonDeleteKeyword, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotDeleteKeyword() ) );
        connect( m_listKeywords, TQ_SIGNAL( selectionChanged() ), this, TQ_SLOT( updateGUI() ) );
        connect( m_listKeywords, TQ_SIGNAL( currentChanged( TQListViewItem * ) ), this, TQ_SLOT( updateGUI() ) );
        connect( m_listKeywords, TQ_SIGNAL( doubleClicked( TQListViewItem*, const TQPoint &, int ) ), this, TQ_SLOT( slotEditKeyword() ) );
        connect( m_listKeywords, TQ_SIGNAL( itemRenamed( TQListViewItem* ) ), this, TQ_SLOT( slotItemRenamed( TQListViewItem* ) ) );

        updateGUI();
    }

}
#include "settingskeyword.moc"
