/*
 * playlistimport.h
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef PLAYLISTIMPORT_H
#define PLAYLISTIMPORT_H

#include "mrl.h"

class TQWidget;

/*
 * static methods for playlist import
 */

class KDE_EXPORT PlaylistImport
{
public:

   static bool kaffeine(const TQString&, TQValueList<MRL>&);
   static bool noatun(const TQString&, TQValueList<MRL>&);
   static bool m3u(const TQString&, TQValueList<MRL>&);
   static bool pls(const TQString&, TQValueList<MRL>&);
   static bool ram(const MRL&, TQValueList<MRL>&, TQWidget*);
   static bool asx(const TQString&, TQValueList<MRL>&);
   static bool smil(const TQString&, const MRL&, TQValueList<MRL>&);
   /* helper */
   static TQTime stringToTime(const TQString&);

private:
   static uint extractIndex(const TQString&);
};

#endif /* PLAYLISTIMPORT_H */
