//
// C++ Interface: k9play
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9PLAY_H
#define K9PLAY_H

#include "k9common.h"
#include "k9dvdtitle.h"
#include <tqfile.h>
/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/

typedef struct {
 uint title;
 uint chapter;
 uint cell;
 uint32_t sector;
 uint64_t bytesWritten;
 uint64_t bytesRead;
 uint64_t bytesSkipped;
 uint64_t bytesChapters;
} k9play_st;


class k9SaveImage;
class k9play{
private:
    int m_title;
    k9DVD *m_dvd;
    k9DVDTitle *m_dvdTitle;
    TQString m_device;
    TQFile *m_output;
    TQFile m_stderr;
    uint32_t m_totalBytes;
    uint32_t m_startSector,m_endSector;
    uint32_t m_pos,m_length;
    double m_vampsFactor;
    uint64_t m_inputSize;
    uint64_t m_totalSize;
    uint64_t m_chapterSize;
    uint64_t m_dvdSize;
    uint m_chapter;
    uint m_cell;
    bool m_initstatus;
    bool m_continue;
    bool m_firstPass;
    bool m_forcedFactor;
    bool m_useCache;
    TQString m_inject;
    TQStringList m_audioFilter;
    TQStringList m_subpictureFilter;
    TQStringList m_chapterList;
    void kdebug(TQString const & _msg);
    bool readNavPack (k9DVDFile *fh, dsi_t *dsi,int sector, uchar *_buffer);
    void insert_dummy_pack (int8_t *buf);
    void insert_nav_pack (int8_t *buf);
    void saveStatus(k9play_st _status);
    void readStatus(k9play_st &_status);
    void flush(k9SaveImage &_saveImage);
public:
    k9play();

    ~k9play();
    void execute();
    void play();
    void writeOutput(TQString const & _msg);

    void setTitle(int _value) {m_title = _value;};

    void setDevice(const TQString& _value) {m_device = _value;};
	
    void setstartSector(TQString _value);
    void setendSector(TQString _value);
    void setaudioFilter(TQString _value);
    void setsubpictureFilter(TQString _value);
    void setchapterList(TQString _value);
    void setvampsFactor(TQString _value);
    void setinputSize(TQString _value);
    void settotalSize(TQString _value);
    void setchapter(TQString _value);
    void setcell(TQString _value);
    void setinject(TQString _value);
    void setdvdSize(TQString _value);
    void setchapterSize(TQString _value);
    void setinitStatus(bool _value);
    void setcontinue (bool _value);
    void setfirstPass (bool _value);
    void setforcedFactor(bool _value);
    void setuseCache(bool _value);
};

#endif
