/**************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/
#ifndef K9DVDAUTHOR_H
#define K9DVDAUTHOR_H

#include "k9common.h"
#include "k9dvd.h"
#include "k9progress.h"

#include <tqdom.h>
#include "k9process.h"
#include <tqdatastream.h>
#include <tqprogressdialog.h>
#include <tdelocale.h>
#include <tdetempfile.h>
/**
  *@author
  */

class k9DVDAuthor : public TQObject  {
Q_OBJECT
  
public:
	k9DVDAuthor(TQObject *DVDStruct,const char* name=0,const TQStringList& args=0) ;
	~k9DVDAuthor();
  virtual void setworkDir( const TQString& _newVal);
  virtual const TQString& getworkDir();
  virtual bool getError();
  virtual void author();
  virtual void setburnDVD( const bool& _newVal);
  virtual const bool& getburnDVD();
  virtual TQWidget *getDialog(){return progress;};
private: // Private attributes
  /**  */
  TQTime *time;
  k9DVD* DVD;
  double factor;
  TQDomDocument *xml;
  TQString lastMsg,totSize,inject;
  k9Process *proc;
  TQString workDir;
  k9Progress *progress;
  bool cancelled;
  bool error;
  bool burnDVD;
  bool m_firsttitle;
  uint64_t m_totalSize;
  uint64_t m_forced,m_forcedsh;
  uint32_t m_copied,m_lastPos;
  uint64_t m_totalPartSize;
  KTempFile *m_xml,*m_inject;
  TQPtrList <KTempFile> files;
  void createXML();
  void addTitle(TQDomElement &root, k9DVDTitle *title);
  void createMenus(bool preview);
  void addMenus(TQDomElement &titleSet);
  void processMenu();
  void spumux();
private slots: // Private slots
  /** No descriptions */
  void DVDAuthorStderr(TDEProcess *proc, char *buffer, int buflen);
  void DVDAuthorStdout(TDEProcess *proc, char *buffer, int buflen);

  /** No descriptions */
  void stopProcess();
};

#endif

