/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// Self
#include "fileoperation.moc"

// TQt
#include <tqcursor.h>
#include <tqpopupmenu.h>
#include <tqobject.h>

// KDE
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>

// Local
#include "fileopobject.h"
#include "fileoperationconfig.h"

namespace Gwenview {


namespace FileOperation {

void copyTo(const KURL::List& srcURL,TQWidget* parent) {
	FileOpObject* op=new FileOpCopyToObject(srcURL,parent);
	(*op)();
}

void linkTo(const KURL::List& srcURL,TQWidget* parent) {
	FileOpObject* op=new FileOpLinkToObject(srcURL,parent);
	(*op)();
}

void moveTo(const KURL::List& srcURL,TQWidget* parent,TQObject* receiver,const char* slot) {
	FileOpObject* op=new FileOpMoveToObject(srcURL,parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(success()),receiver,slot);
	(*op)();
}

void makeDir(const KURL& parentURL, TQWidget* parent, TQObject* receiver, const char* slot) {
    FileOpObject* op=new FileOpMakeDirObject(parentURL, parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(success()),receiver,slot);
	(*op)();
}

void del(const KURL::List& url,TQWidget* parent,TQObject* receiver,const char* slot) {
	FileOpObject* op = new FileOpDelObject(url,parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(success()),receiver,slot);
	(*op)();
}


void trash(const KURL::List& url, TQWidget* parent, TQObject* receiver, const char* slot) {
	FileOpObject* op = new FileOpTrashObject(url,parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(success()),receiver,slot);
	(*op)();
}


void realDelete(const KURL::List& url, TQWidget* parent, TQObject* receiver, const char* slot) {
	FileOpObject* op = new FileOpRealDeleteObject(url,parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(success()),receiver,slot);
	(*op)();
}


void rename(const KURL& url,TQWidget* parent,TQObject* receiver,const char* slot) {
	FileOpObject* op=new FileOpRenameObject(url,parent);
	if (receiver && slot) TQObject::connect(op,TQT_SIGNAL(renamed(const TQString&)),receiver,slot);
	(*op)();
}


void fillDropURLMenu(TQPopupMenu* menu, const KURL::List& urls, const KURL& target, bool* wasMoved) {
	DropMenuContext* context=new DropMenuContext(TQT_TQOBJECT(menu), urls, target, wasMoved);
	menu->insertItem( SmallIcon("goto"), i18n("&Move Here"),
		context, TQT_SLOT(move()) );
	menu->insertItem( SmallIcon("edit-copy"), i18n("&Copy Here"),
		context, TQT_SLOT(copy()) );
	menu->insertItem( SmallIcon("www"), i18n("&Link Here"),
		context, TQT_SLOT(link()) );
}


void openDropURLMenu(TQWidget* parent, const KURL::List& urls, const KURL& target, bool* wasMoved) {
	TQPopupMenu menu(parent);
	if (wasMoved) *wasMoved=false;

	fillDropURLMenu(&menu, urls, target, wasMoved);
	menu.insertSeparator();
	menu.insertItem( SmallIcon("cancel"), i18n("Cancel") );

	menu.setMouseTracking(true);
	menu.exec(TQCursor::pos());
}


} // namespace FileOperation

} // namespace
