/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-05-03
 * Description : mime types setup tab
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqhbox.h>
#include <tqhgroupbox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqwhatsthis.h>
#include <tqtoolbutton.h>
#include <tqtooltip.h>

// KDE includes.

#include <tdelocale.h>
#include <kdialog.h>
#include <klineeditdlg.h>
#include <kiconloader.h>

// Local includes.

#include "albumsettings.h"
#include "setupmime.h"
#include "setupmime.moc"

namespace Digikam
{

class SetupMimePriv
{
public:

    SetupMimePriv()
    {
        imageFileFilterEdit      = 0;
        movieFileFilterEdit      = 0;
        audioFileFilterEdit      = 0;
        rawFileFilterEdit        = 0;
        revertImageFileFilterBtn = 0;
        revertMovieFileFilterBtn = 0;
        revertAudioFileFilterBtn = 0;
        revertRawFileFilterBtn   = 0;
    }

    TQToolButton *revertImageFileFilterBtn;
    TQToolButton *revertMovieFileFilterBtn;
    TQToolButton *revertAudioFileFilterBtn;
    TQToolButton *revertRawFileFilterBtn;

    TQLineEdit   *imageFileFilterEdit;
    TQLineEdit   *movieFileFilterEdit;
    TQLineEdit   *audioFileFilterEdit;
    TQLineEdit   *rawFileFilterEdit;
};

SetupMime::SetupMime(TQWidget* parent )
         : TQWidget(parent)
{
    d = new SetupMimePriv;
    TQVBoxLayout *layout = new TQVBoxLayout(parent, 0, KDialog::spacingHint());
    
    // --------------------------------------------------------
    
    TQGroupBox *imageFileFilterBox = new TQGroupBox(0, Qt::Horizontal, i18n("Image Files"), parent);
    TQGridLayout* grid1            = new TQGridLayout(imageFileFilterBox->layout(), 1, 1, KDialog::spacingHint());

    TQLabel *logoLabel1 = new TQLabel(imageFileFilterBox);
    logoLabel1->setPixmap(DesktopIcon("image-x-generic"));

    TQLabel *imageFileFilterLabel = new TQLabel(imageFileFilterBox);
    imageFileFilterLabel->setText(i18n("Show only &image files with extensions:"));
    
    TQHBox *hbox1 = new TQHBox(imageFileFilterBox);    
    d->imageFileFilterEdit = new TQLineEdit(hbox1);
    TQWhatsThis::add( d->imageFileFilterEdit, i18n("<p>Here you can set the extensions of image files "
                                                  "to be displayed in Albums (such as JPEG or TIFF); "
                                                  "clicking on these files will "
                                                  "open them in the digiKam Image Editor."));
    imageFileFilterLabel->setBuddy(d->imageFileFilterEdit);
    hbox1->setStretchFactor(d->imageFileFilterEdit, 10);

    d->revertImageFileFilterBtn = new TQToolButton(hbox1);
    d->revertImageFileFilterBtn->setIconSet(SmallIcon("reload_page"));
    TQToolTip::add(d->revertImageFileFilterBtn, i18n("Revert to default settings"));
 
    grid1->addMultiCellWidget(logoLabel1, 0, 1, 0, 0);
    grid1->addMultiCellWidget(imageFileFilterLabel, 0, 0, 1, 1);
    grid1->addMultiCellWidget(hbox1, 1, 1, 1, 1);
    grid1->setColStretch(1, 10);

    layout->addWidget(imageFileFilterBox);
    
    // --------------------------------------------------------
    
    TQGroupBox *movieFileFilterBox = new TQGroupBox(0, Qt::Horizontal, i18n("Movie Files"), parent);
    TQGridLayout* grid2            = new TQGridLayout(movieFileFilterBox->layout(), 1, 1, KDialog::spacingHint());

    TQLabel *logoLabel2 = new TQLabel(movieFileFilterBox);
    logoLabel2->setPixmap(DesktopIcon("video-x-generic"));

    TQLabel *movieFileFilterLabel = new TQLabel(movieFileFilterBox);
    movieFileFilterLabel->setText(i18n("Show only &movie files with extensions:"));
    
    TQHBox *hbox2 = new TQHBox(movieFileFilterBox);    
    d->movieFileFilterEdit = new TQLineEdit(hbox2);
    TQWhatsThis::add( d->movieFileFilterEdit, i18n("<p>Here you can set the extensions of movie files "
                                                  "to be displayed in Albums (such as MPEG or AVI); "
                                                  "clicking on these files will "
                                                  "open them with the default TDE movie player."));
    movieFileFilterLabel->setBuddy(d->movieFileFilterEdit);
    hbox2->setStretchFactor(d->movieFileFilterEdit, 10);

    d->revertMovieFileFilterBtn = new TQToolButton(hbox2);
    d->revertMovieFileFilterBtn->setIconSet(SmallIcon("reload_page"));
    TQToolTip::add(d->revertMovieFileFilterBtn, i18n("Revert to default settings"));

    grid2->addMultiCellWidget(logoLabel2, 0, 1, 0, 0);
    grid2->addMultiCellWidget(movieFileFilterLabel, 0, 0, 1, 1);
    grid2->addMultiCellWidget(hbox2, 1, 1, 1, 1);
    grid2->setColStretch(1, 10);

    layout->addWidget(movieFileFilterBox);
    
    // --------------------------------------------------------
    
    TQGroupBox *audioFileFilterBox = new TQGroupBox(0, Qt::Horizontal, i18n("Audio Files"), parent);
    TQGridLayout* grid3            = new TQGridLayout(audioFileFilterBox->layout(), 1, 1, KDialog::spacingHint());

    TQLabel *logoLabel3 = new TQLabel(audioFileFilterBox);
    logoLabel3->setPixmap(DesktopIcon("audio-x-generic"));

    TQLabel *audioFileFilterLabel = new TQLabel(audioFileFilterBox);
    audioFileFilterLabel->setText(i18n("Show only &audio files with extensions:"));
    
    TQHBox *hbox3 = new TQHBox(audioFileFilterBox);  
    d->audioFileFilterEdit = new TQLineEdit(hbox3);
    TQWhatsThis::add( d->audioFileFilterEdit, i18n("<p>Here you can set the extensions of audio files "
                                                  "to be displayed in Albums (such as MP3 or OGG); "
                                                  "clicking on these files will "
                                                  "open them with the default TDE audio player."));
    audioFileFilterLabel->setBuddy(d->audioFileFilterEdit);
    hbox3->setStretchFactor(d->audioFileFilterEdit, 10);

    d->revertAudioFileFilterBtn = new TQToolButton(hbox3);
    d->revertAudioFileFilterBtn->setIconSet(SmallIcon("reload_page"));
    TQToolTip::add(d->revertAudioFileFilterBtn, i18n("Revert to default settings"));

    grid3->addMultiCellWidget(logoLabel3, 0, 1, 0, 0);
    grid3->addMultiCellWidget(audioFileFilterLabel, 0, 0, 1, 1);
    grid3->addMultiCellWidget(hbox3, 1, 1, 1, 1);
    grid3->setColStretch(1, 10);

    layout->addWidget(audioFileFilterBox);
    
    // --------------------------------------------------------
    
    TQGroupBox *rawFileFilterBox = new TQGroupBox(0, Qt::Horizontal, i18n("RAW Files"), parent);
    TQGridLayout* grid4          = new TQGridLayout(rawFileFilterBox->layout(), 1, 1, KDialog::spacingHint());

    TQLabel *logoLabel4 = new TQLabel(rawFileFilterBox);
    logoLabel4->setPixmap(DesktopIcon("kdcraw"));

    TQLabel *rawFileFilterLabel = new TQLabel(rawFileFilterBox);
    rawFileFilterLabel->setText(i18n("Show only &RAW files with extensions:"));
    
    TQHBox *hbox4 = new TQHBox(rawFileFilterBox);  
    d->rawFileFilterEdit = new TQLineEdit(hbox4);
    TQWhatsThis::add( d->rawFileFilterEdit, i18n("<p>Here you can set the extensions of RAW image files "
                                                "to be displayed in Albums (such as CRW, for Canon cameras, "
                                                "or NEF, for Nikon cameras)."));
    rawFileFilterLabel->setBuddy(d->rawFileFilterEdit);
    hbox4->setStretchFactor(d->rawFileFilterEdit, 10);

    d->revertRawFileFilterBtn = new TQToolButton(hbox4);
    d->revertRawFileFilterBtn->setIconSet(SmallIcon("reload_page"));
    TQToolTip::add(d->revertRawFileFilterBtn, i18n("Revert to default settings"));

    grid4->addMultiCellWidget(logoLabel4, 0, 1, 0, 0);
    grid4->addMultiCellWidget(rawFileFilterLabel, 0, 0, 1, 1);
    grid4->addMultiCellWidget(hbox4, 1, 1, 1, 1);
    grid4->setColStretch(1, 10);

    layout->addWidget(rawFileFilterBox);
    layout->addStretch();
    
    // --------------------------------------------------------
    
    connect(d->revertImageFileFilterBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotRevertImageFileFilter()));

    connect(d->revertMovieFileFilterBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotRevertMovieFileFilter()));

    connect(d->revertAudioFileFilterBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotRevertAudioFileFilter()));

    connect(d->revertRawFileFilterBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotRevertRawFileFilter()));

    // --------------------------------------------------------
    
    readSettings();
}

SetupMime::~SetupMime()
{
    delete d;
}

void SetupMime::applySettings()
{
    AlbumSettings* settings = AlbumSettings::instance();

    if (!settings) return;

    settings->setImageFileFilter(d->imageFileFilterEdit->text());
    settings->setMovieFileFilter(d->movieFileFilterEdit->text());
    settings->setAudioFileFilter(d->audioFileFilterEdit->text());
    settings->setRawFileFilter(d->rawFileFilterEdit->text());

    settings->saveSettings();
}

void SetupMime::readSettings()
{
    AlbumSettings* settings = AlbumSettings::instance();

    if (!settings) return;

    d->imageFileFilterEdit->setText(settings->getImageFileFilter());
    d->movieFileFilterEdit->setText(settings->getMovieFileFilter());
    d->audioFileFilterEdit->setText(settings->getAudioFileFilter());
    d->rawFileFilterEdit->setText(settings->getRawFileFilter());
}

void SetupMime::slotRevertImageFileFilter()
{
    d->imageFileFilterEdit->setText(AlbumSettings::instance()->getDefaultImageFileFilter());
}

void SetupMime::slotRevertMovieFileFilter()
{
    d->movieFileFilterEdit->setText(AlbumSettings::instance()->getDefaultMovieFileFilter());
}

void SetupMime::slotRevertAudioFileFilter()
{
    d->audioFileFilterEdit->setText(AlbumSettings::instance()->getDefaultAudioFileFilter());
}

void SetupMime::slotRevertRawFileFilter()
{
    d->rawFileFilterEdit->setText(AlbumSettings::instance()->getDefaultRawFileFilter());
}

}  // namespace Digikam

