/***************************************************************************
begin                : 2004/02/25
copyright            : (C) Frederik Holljen
email                : fh@ez.no
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "amarokconfig.h"
#include <tdelocale.h>
#include <tdeapplication.h>
#include "qstringx.h"
#include <tqtooltip.h>


void Options5::init()
{
    m_pOSDPreview = new OSDPreviewWidget( this ); //must be child!!!
    m_pOSDPreview->setAlignment( static_cast<OSDWidget::Alignment>( AmarokConfig::osdAlignment() ) );
    m_pOSDPreview->setOffset( AmarokConfig::osdYOffset() );

    connect( m_pOSDPreview, TQT_SIGNAL( positionChanged() ), TQT_SLOT( slotPositionChanged() ) );

    const int numScreens = TQApplication::desktop()->numScreens();
    for( int i = 0; i < numScreens; i++ )
        kcfg_OsdScreen->insertItem( TQString::number( i ) );

    connect( kcfg_OsdDrawShadow,          TQT_SIGNAL( toggled(bool) ),
             m_pOSDPreview,               TQT_SLOT( setDrawShadow(bool) ) );
    connect( kcfg_OsdTextColor,           TQT_SIGNAL( changed(const TQColor&) ),
             m_pOSDPreview,               TQT_SLOT( setTextColor(const TQColor&) ) );
    connect( kcfg_OsdUseCustomColors,     TQT_SIGNAL( toggled(bool) ),
             this,                        TQT_SLOT( useCustomColorsToggled(bool) ) );
    connect( kcfg_OsdUseFakeTranslucency, TQT_SIGNAL( toggled(bool) ),
             this,                        TQT_SLOT( useFakeTransparencyToggled(bool) ) );
    connect( kcfg_OsdBackgroundColor,     TQT_SIGNAL( changed(const TQColor&) ),
             m_pOSDPreview,               TQT_SLOT( setBackgroundColor(const TQColor&) ) );
    connect( kcfg_OsdFont,                TQT_SIGNAL( fontSelected(const TQFont&) ),
             m_pOSDPreview,               TQT_SLOT( setFont(const TQFont&) ) );
    connect( kcfg_OsdScreen,              TQT_SIGNAL( activated(int) ),
             m_pOSDPreview,               TQT_SLOT( setScreen(int) ) );
    connect( kcfg_OsdEnabled,             TQT_SIGNAL( toggled(bool) ),
             m_pOSDPreview,               TQT_SLOT( setShown(bool) ) );

    Amarok::QStringx text = i18n(
            "<h3>Tags Displayed in OSD</h3>"
            "You can use the following tokens:"
                "<ul>"
                "<li>Title - %1"
                "<li>Album - %2"
                "<li>Artist - %3"
                "<li>Genre - %4"
                "<li>Bitrate - %5"
                "<li>Year - %6"
                "<li>Track Length - %7"
                "<li>Track Number - %8"
                "<li>Filename - %9"
                "<li>Directory - %10"
                "<li>Type - %11"
                "<li>Comment - %12"
                "<li>Score - %13"
                "<li>Playcount - %14"
                "<li>Disc Number - %15"
                "<li>Rating - %16"
                "<li>Moodbar - %17"
		"<li>Elapsed Time - %18"
                "</ul>"
            "If you surround sections of text that contain a token with curly-braces, that section will be hidden if the token is empty, for example:"
                "<pre>%19</pre>"
            "Will not show <b>Score: <i>%score</i></b> if the track has no score." );

    TQToolTip::add( kcfg_OsdText, text.args( TQStringList()
            // we don't translate these, it is not sensible to do so
            << "%title"  << "%album"   << "%artist"  << "%genre"     << "%bitrate"
            << "%year "  << "%length"  << "%track"   << "%filename"  << "%directory"
            << "%type"   << "%comment" << "%score"   << "%playcount" << "%discnumber"
            << "%rating" << "%moodbar" << "%elapsed"
            << "%title {" + i18n( "Score: %1" ).arg( "%score" ) +'}' ) );
}

void
Options5::slotPositionChanged()
{
    kcfg_OsdScreen->blockSignals( true );
    kcfg_OsdScreen->setCurrentItem( m_pOSDPreview->screen() );
    kcfg_OsdScreen->blockSignals( false );

    // Update button states (e.g. "Apply")
    emit settingsChanged();
}

void
Options5::hideEvent( TQHideEvent* )
{
    m_pOSDPreview->hide();
}

void
Options5::showEvent( TQShowEvent* )
{
    useCustomColorsToggled( kcfg_OsdUseCustomColors->isChecked() );
    useFakeTransparencyToggled( kcfg_OsdUseFakeTranslucency->isChecked() );

    m_pOSDPreview->setFont( kcfg_OsdFont->font() );
    m_pOSDPreview->setScreen( kcfg_OsdScreen->currentItem() );
    m_pOSDPreview->setShown( kcfg_OsdEnabled->isChecked() );
}

void
Options5::useCustomColorsToggled( bool on )
{
    m_pOSDPreview->setUseCustomColors( on, kcfg_OsdTextColor->color(), kcfg_OsdBackgroundColor->color() );
}

void
Options5::useFakeTransparencyToggled( bool on )
{
    if (kapp->isX11CompositionAvailable())
        m_pOSDPreview->setTranslucency( on );
    else
        m_pOSDPreview->setTranslucency( false );
}
