// File autogenerated

// declaration include
#include "agentmanager1Proxy.h"

// TQt D-Bus includes
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>


namespace org
{
namespace bluez
{
namespace obex
{

AgentManager1Proxy::AgentManager1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.obex.AgentManager1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

AgentManager1Proxy::~AgentManager1Proxy()
{
    delete m_baseProxy;
}

void AgentManager1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool AgentManager1Proxy::RegisterAgent(const TQT_DBusObjectPath& agent, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(agent);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("RegisterAgent", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool AgentManager1Proxy::UnregisterAgent(const TQT_DBusObjectPath& agent, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(agent);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("UnregisterAgent", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

}; // namespace obex

}; // namespace bluez

}; // namespace org

#include "agentmanager1Proxy.moc"

// End of File

